/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Drawable;
import com.pdfjet.Font;
import com.pdfjet.GS1_128;
import com.pdfjet.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BarCode
implements Drawable {
    public static final int UPC = 0;
    public static final int CODE128 = 1;
    public static final int CODE39 = 2;
    public static final int LEFT_TO_RIGHT = 0;
    public static final int TOP_TO_BOTTOM = 1;
    public static final int BOTTOM_TO_TOP = 2;
    private int[] tableA = new int[]{3211, 2221, 2122, 1411, 1132, 1231, 1114, 1312, 1213, 3112};
    private float x1 = 0.0f;
    private float y1 = 0.0f;
    private float m1 = 0.75f;
    private float barHeightFactor = 50.0f;
    private int type = 0;
    private int direction = 0;
    private String str = null;
    private Font font = null;
    private Map<Character, String> map = new HashMap<Character, String>();

    public BarCode(int n, String string) {
        this.type = n;
        this.str = string;
        this.map.put(Character.valueOf('*'), "bWbwBwBwb");
        this.map.put(Character.valueOf('-'), "bWbwbwBwB");
        this.map.put(Character.valueOf('$'), "bWbWbWbwb");
        this.map.put(Character.valueOf('%'), "bwbWbWbWb");
        this.map.put(Character.valueOf(' '), "bWBwbwBwb");
        this.map.put(Character.valueOf('.'), "BWbwbwBwb");
        this.map.put(Character.valueOf('/'), "bWbWbwbWb");
        this.map.put(Character.valueOf('+'), "bWbwbWbWb");
        this.map.put(Character.valueOf('0'), "bwbWBwBwb");
        this.map.put(Character.valueOf('1'), "BwbWbwbwB");
        this.map.put(Character.valueOf('2'), "bwBWbwbwB");
        this.map.put(Character.valueOf('3'), "BwBWbwbwb");
        this.map.put(Character.valueOf('4'), "bwbWBwbwB");
        this.map.put(Character.valueOf('5'), "BwbWBwbwb");
        this.map.put(Character.valueOf('6'), "bwBWBwbwb");
        this.map.put(Character.valueOf('7'), "bwbWbwBwB");
        this.map.put(Character.valueOf('8'), "BwbWbwBwb");
        this.map.put(Character.valueOf('9'), "bwBWbwBwb");
        this.map.put(Character.valueOf('A'), "BwbwbWbwB");
        this.map.put(Character.valueOf('B'), "bwBwbWbwB");
        this.map.put(Character.valueOf('C'), "BwBwbWbwb");
        this.map.put(Character.valueOf('D'), "bwbwBWbwB");
        this.map.put(Character.valueOf('E'), "BwbwBWbwb");
        this.map.put(Character.valueOf('F'), "bwBwBWbwb");
        this.map.put(Character.valueOf('G'), "bwbwbWBwB");
        this.map.put(Character.valueOf('H'), "BwbwbWBwb");
        this.map.put(Character.valueOf('I'), "bwBwbWBwb");
        this.map.put(Character.valueOf('J'), "bwbwBWBwb");
        this.map.put(Character.valueOf('K'), "BwbwbwbWB");
        this.map.put(Character.valueOf('L'), "bwBwbwbWB");
        this.map.put(Character.valueOf('M'), "BwBwbwbWb");
        this.map.put(Character.valueOf('N'), "bwbwBwbWB");
        this.map.put(Character.valueOf('O'), "BwbwBwbWb");
        this.map.put(Character.valueOf('P'), "bwBwBwbWb");
        this.map.put(Character.valueOf('Q'), "bwbwbwBWB");
        this.map.put(Character.valueOf('R'), "BwbwbwBWb");
        this.map.put(Character.valueOf('S'), "bwBwbwBWb");
        this.map.put(Character.valueOf('T'), "bwbwBwBWb");
        this.map.put(Character.valueOf('U'), "BWbwbwbwB");
        this.map.put(Character.valueOf('V'), "bWBwbwbwB");
        this.map.put(Character.valueOf('W'), "BWBwbwbwb");
        this.map.put(Character.valueOf('X'), "bWbwBwbwB");
        this.map.put(Character.valueOf('Y'), "BWbwBwbwb");
        this.map.put(Character.valueOf('Z'), "bWBwBwbwb");
    }

    public void setPosition(double d, double d2) {
        this.setPosition((float)d, (float)d2);
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.x1 = f;
        this.y1 = f2;
    }

    public void setModuleLength(double d) {
        this.m1 = (float)d;
    }

    public void setModuleLength(float f) {
        this.m1 = f;
    }

    public void setBarHeightFactor(double d) {
        this.barHeightFactor = (float)d;
    }

    public void setBarHeightFactor(float f) {
        this.barHeightFactor = f;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void drawOn(Page page) throws Exception {
        if (this.type == 0) {
            this.drawCodeUPC(page);
        } else if (this.type == 1) {
            this.drawCode128(page);
        } else if (this.type == 2) {
            this.drawCode39(page);
        }
    }

    private void drawCodeUPC(Page page) throws Exception {
        int n;
        int n2;
        String string;
        int n3;
        int n4;
        int n5;
        float f = this.x1;
        float f2 = this.y1;
        float f3 = this.m1 * this.barHeightFactor;
        int n6 = 0;
        for (n5 = 0; n5 < 11; n5 += 2) {
            n6 += this.str.charAt(n5) - 48;
        }
        n6 *= 3;
        for (n5 = 1; n5 < 11; n5 += 2) {
            n6 += this.str.charAt(n5) - 48;
        }
        n5 = n6 % 10;
        int n7 = (10 - n5) % 10;
        this.str = this.str + Integer.toString(n7);
        f = this.drawEGuard(page, f, f2, this.m1, f3 + 8.0f);
        for (n4 = 0; n4 < 6; ++n4) {
            n3 = this.str.charAt(n4) - 48;
            string = Integer.toString(this.tableA[n3]);
            for (n2 = 0; n2 < string.length(); ++n2) {
                n = string.charAt(n2) - 48;
                if (n2 % 2 != 0) {
                    this.drawVertBar(page, f, f2, (float)n * this.m1, f3);
                }
                f += (float)n * this.m1;
            }
        }
        f = this.drawMGuard(page, f, f2, this.m1, f3 + 8.0f);
        for (n4 = 6; n4 < 12; ++n4) {
            n3 = this.str.charAt(n4) - 48;
            string = Integer.toString(this.tableA[n3]);
            for (n2 = 0; n2 < string.length(); ++n2) {
                n = string.charAt(n2) - 48;
                if (n2 % 2 == 0) {
                    this.drawVertBar(page, f, f2, (float)n * this.m1, f3);
                }
                f += (float)n * this.m1;
            }
        }
        f = this.drawEGuard(page, f, f2, this.m1, f3 + 8.0f);
        if (this.font != null) {
            String string2 = this.str.charAt(0) + "  " + this.str.charAt(1) + this.str.charAt(2) + this.str.charAt(3) + this.str.charAt(4) + this.str.charAt(5) + "   " + this.str.charAt(6) + this.str.charAt(7) + this.str.charAt(8) + this.str.charAt(9) + this.str.charAt(10) + "  " + this.str.charAt(11);
            float f4 = this.font.getSize();
            this.font.setSize(10.0);
            page.drawString(this.font, string2, this.x1 + (f - this.x1 - this.font.stringWidth(string2)) / 2.0f, this.y1 + f3 + this.font.body_height);
            this.font.setSize(f4);
        }
    }

    private float drawEGuard(Page page, float f, float f2, float f3, float f4) throws Exception {
        this.drawBar(page, f + 0.5f * f3, f2, f3, f4);
        this.drawBar(page, f + 2.5f * f3, f2, f3, f4);
        return f + 3.0f * f3;
    }

    private float drawMGuard(Page page, float f, float f2, float f3, float f4) throws Exception {
        this.drawBar(page, f + 1.5f * f3, f2, f3, f4);
        this.drawBar(page, f + 3.5f * f3, f2, f3, f4);
        return f + 5.0f * f3;
    }

    private void drawBar(Page page, float f, float f2, float f3, float f4) throws Exception {
        page.setPenWidth(f3);
        page.moveTo(f, f2);
        page.lineTo(f, f2 + f4);
        page.strokePath();
    }

    private void drawCode128(Page page) throws Exception {
        int n;
        int n2;
        int n3;
        float f = this.x1;
        float f2 = this.y1;
        float f3 = this.m1;
        float f4 = this.m1;
        if (this.direction == 1) {
            f3 *= this.barHeightFactor;
        } else if (this.direction == 0) {
            f4 *= this.barHeightFactor;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.str.length(); ++i) {
            n3 = this.str.charAt(i);
            if (n3 < 32) {
                arrayList.add(98);
                arrayList.add(n3 + 64);
            } else {
                arrayList.add(n3 - 32);
            }
            if (arrayList.size() == 48) break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        n3 = 104;
        stringBuilder.append((char)n3);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            n = (Integer)arrayList.get(n2);
            stringBuilder.append((char)n);
            n3 += n * (n2 + 1);
        }
        stringBuilder.append((char)(n3 %= 103));
        stringBuilder.append('j');
        for (n2 = 0; n2 < stringBuilder.length(); ++n2) {
            n = stringBuilder.charAt(n2);
            String string = Integer.toString(GS1_128.TABLE[n]);
            for (int i = 0; i < string.length(); ++i) {
                int n4 = string.charAt(i) - 48;
                if (i % 2 == 0) {
                    if (this.direction == 0) {
                        this.drawVertBar(page, f, f2, this.m1 * (float)n4, f4);
                    } else if (this.direction == 1) {
                        this.drawHorzBar(page, f, f2, this.m1 * (float)n4, f3);
                    }
                }
                if (this.direction == 0) {
                    f += (float)n4 * this.m1;
                    continue;
                }
                if (this.direction != 1) continue;
                f2 += (float)n4 * this.m1;
            }
        }
        if (this.font != null) {
            if (this.direction == 0) {
                page.drawString(this.font, this.str, this.x1 + (f - this.x1 - this.font.stringWidth(this.str)) / 2.0f, this.y1 + f4 + this.font.body_height);
            } else if (this.direction == 1) {
                page.setTextDirection(90);
                page.drawString(this.font, this.str, f + f3 + this.font.body_height, f2 - (f2 - this.y1 - this.font.stringWidth(this.str)) / 2.0f);
                page.setTextDirection(0);
            }
        }
    }

    private void drawCode39(Page page) throws Exception {
        this.str = "*" + this.str + "*";
        float f = this.x1;
        float f2 = this.y1;
        float f3 = this.m1 * this.barHeightFactor;
        float f4 = this.m1 * this.barHeightFactor;
        if (this.direction == 0) {
            for (int i = 0; i < this.str.length(); ++i) {
                String string = this.map.get(Character.valueOf(this.str.charAt(i)));
                if (string == null) {
                    throw new Exception("The input string '" + this.str + "' contains characters that are invalid in a Code39 barcode.");
                }
                for (int j = 0; j < 9; ++j) {
                    char c = string.charAt(j);
                    if (c == 'w') {
                        f += this.m1;
                        continue;
                    }
                    if (c == 'W') {
                        f += this.m1 * 3.0f;
                        continue;
                    }
                    if (c == 'b') {
                        this.drawVertBar(page, f, f2, this.m1, f4);
                        f += this.m1;
                        continue;
                    }
                    if (c != 'B') continue;
                    this.drawVertBar(page, f, f2, this.m1 * 3.0f, f4);
                    f += this.m1 * 3.0f;
                }
                f += this.m1;
            }
            if (this.font != null) {
                page.drawString(this.font, this.str, this.x1 + (f - this.x1 - this.font.stringWidth(this.str)) / 2.0f, this.y1 + f4 + this.font.body_height);
            }
        } else if (this.direction == 1) {
            for (int i = 0; i < this.str.length(); ++i) {
                String string = this.map.get(Character.valueOf(this.str.charAt(i)));
                if (string == null) {
                    throw new Exception("The input string '" + this.str + "' contains characters that are invalid in a Code39 barcode.");
                }
                for (int j = 0; j < 9; ++j) {
                    char c = string.charAt(j);
                    if (c == 'w') {
                        f2 += this.m1;
                        continue;
                    }
                    if (c == 'W') {
                        f2 += 3.0f * this.m1;
                        continue;
                    }
                    if (c == 'b') {
                        this.drawHorzBar(page, f, f2, this.m1, f4);
                        f2 += this.m1;
                        continue;
                    }
                    if (c != 'B') continue;
                    this.drawHorzBar(page, f, f2, 3.0f * this.m1, f4);
                    f2 += 3.0f * this.m1;
                }
                f2 += this.m1;
            }
            if (this.font != null) {
                page.setTextDirection(270);
                page.drawString(this.font, this.str, f - this.font.body_height, this.y1 + (f2 - this.y1 - this.font.stringWidth(this.str)) / 2.0f);
                page.setTextDirection(0);
            }
        } else if (this.direction == 2) {
            char c;
            int n;
            String string;
            int n2;
            float f5 = 0.0f;
            for (n2 = 0; n2 < this.str.length(); ++n2) {
                string = this.map.get(Character.valueOf(this.str.charAt(n2)));
                if (string == null) {
                    throw new Exception("The input string '" + this.str + "' contains characters that are invalid in a Code39 barcode.");
                }
                for (n = 0; n < 9; ++n) {
                    c = string.charAt(n);
                    if (c == 'w' || c == 'b') {
                        f5 += this.m1;
                        continue;
                    }
                    if (c != 'W' && c != 'B') continue;
                    f5 += 3.0f * this.m1;
                }
                f5 += this.m1;
            }
            f2 += f5 - this.m1;
            for (n2 = 0; n2 < this.str.length(); ++n2) {
                string = this.map.get(Character.valueOf(this.str.charAt(n2)));
                for (n = 0; n < 9; ++n) {
                    c = string.charAt(n);
                    if (c == 'w') {
                        f2 -= this.m1;
                        continue;
                    }
                    if (c == 'W') {
                        f2 -= 3.0f * this.m1;
                        continue;
                    }
                    if (c == 'b') {
                        this.drawHorzBar2(page, f, f2, this.m1, f4);
                        f2 -= this.m1;
                        continue;
                    }
                    if (c != 'B') continue;
                    this.drawHorzBar2(page, f, f2, 3.0f * this.m1, f4);
                    f2 -= 3.0f * this.m1;
                }
                f2 -= this.m1;
            }
            if (this.font != null) {
                f2 = this.y1 + (f5 - this.m1);
                page.setTextDirection(90);
                page.drawString(this.font, this.str, f + f3 + this.font.body_height, f2 - (f2 - this.y1 - this.font.stringWidth(this.str)) / 2.0f);
                page.setTextDirection(0);
            }
        }
    }

    private void drawVertBar(Page page, float f, float f2, float f3, float f4) throws Exception {
        page.setPenWidth(f3);
        page.moveTo(f + f3 / 2.0f, f2);
        page.lineTo(f + f3 / 2.0f, f2 + f4);
        page.strokePath();
    }

    private void drawHorzBar(Page page, float f, float f2, float f3, float f4) throws Exception {
        page.setPenWidth(f3);
        page.moveTo(f, f2 + f3 / 2.0f);
        page.lineTo(f + f4, f2 + f3 / 2.0f);
        page.strokePath();
    }

    private void drawHorzBar2(Page page, float f, float f2, float f3, float f4) throws Exception {
        page.setPenWidth(f3);
        page.moveTo(f, f2 - f3 / 2.0f);
        page.lineTo(f + f4, f2 - f3 / 2.0f);
        page.strokePath();
    }
}

