/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc.encoders;

import java.io.IOException;
import java.util.Arrays;
import utils.vnc.PixelFormat;
import utils.vnc.VNC;
import utils.vnc.encoders.datatarget.ImageDataInterface;
import utils.vnc.utils.PixelInputStream;

public class CoRREDecoder {
    public static void doDecoding(PixelInputStream in, int xpos, int ypos, int width, int height, ImageDataInterface image, PixelFormat format) throws IOException {
        if (VNC.VNC_DEBUG_ENCODINGS) {
            System.out.println("[CoRRE] Start Decoding");
        }
        int[] pixels = image.getPixels();
        int numberOfSubRectangles = in.readInt();
        int backgroundColor = in.readPixel();
        int imageWidth = image.getWidth();
        for (int y = 0; y < height; ++y) {
            int startLine = (y + ypos) * imageWidth + xpos;
            Arrays.fill(pixels, startLine, startLine + width, backgroundColor);
        }
        for (int i = 0; i < numberOfSubRectangles; ++i) {
            int subRectColor = in.readPixel();
            int x = in.readUnsignedByte();
            int y = in.readUnsignedByte();
            int w = in.readUnsignedByte();
            int h = in.readUnsignedByte();
            for (int yindex = 0; yindex < h; ++yindex) {
                int startLine = (y + ypos + yindex) * imageWidth + xpos + x;
                Arrays.fill(pixels, startLine, startLine + w, subRectColor);
            }
        }
    }
}

