/*
 * Decompiled with CFR 0.152.
 */
package utils.udp.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import utils.stream.OpenByteArrayOutputStream;
import utils.stream.StreamUtils;

public class UDPWrapUtil {
    private static final short UDP_MAGIC_SHORT = -8191;

    public DatagramPacket wrap(byte[] b) throws IOException {
        return this.wrap(b, 0, b.length);
    }

    public DatagramPacket wrap(byte[] b, int off, int len) throws IOException {
        OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();
        bout.reset();
        StreamUtils.writeShort((OutputStream)bout, (short)-8191);
        StreamUtils.writeInt((OutputStream)bout, (int)len);
        bout.write(b, off, len);
        DatagramPacket packet = new DatagramPacket(bout.getByteArray(), 0, bout.size());
        return packet;
    }

    public byte[] unwrap(DatagramPacket packet) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(packet.getData());
        short MAGIC = StreamUtils.readShort((InputStream)bin);
        if (MAGIC != -8191) {
            throw new IOException("Not a valid UDPWrapUtil packet");
        }
        int LEN = StreamUtils.readInt((InputStream)bin);
        if (LEN < 0 || LEN > 100000) {
            throw new IOException("Invalid UDPWrapUtil packet length");
        }
        byte[] dat = StreamUtils.readBytes((InputStream)bin, (int)LEN);
        return dat;
    }
}

