/*
 * Decompiled with CFR 0.152.
 */
package utils.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;

public class WakeOnLan {
    public static final int PORT = 7;

    public static byte[] getAddrBytes(String addr) throws Exception {
        String[] tmp = addr.split("\\.");
        byte[] baddr = new byte[4];
        for (int i = 0; i < tmp.length; ++i) {
            int x = Integer.parseInt(tmp[i]);
            baddr[i] = (byte)x;
        }
        return baddr;
    }

    public static boolean isBroadcastIP(byte[] addr) {
        return addr[3] == -1;
    }

    public static void main(String[] args) throws Exception {
        String addr = "192.168.0.25";
        InetAddress orig = InetAddress.getByName(addr);
        String[] tmp = addr.split("\\.");
        byte[] baddr = new byte[4];
        for (int i = 0; i < tmp.length; ++i) {
            int x = Integer.parseInt(tmp[i]);
            System.out.println(x);
            baddr[i] = (byte)x;
        }
        InetAddress next = InetAddress.getByAddress(baddr);
        System.out.println(orig);
        System.out.println(next);
        System.out.println(WakeOnLan.isBroadcastIP(baddr));
        baddr[3] = -1;
        System.out.println(WakeOnLan.isBroadcastIP(baddr));
        System.out.println("Doing WOL");
        WakeOnLan.doWOL(new byte[]{-64, -88, 1, -56}, new byte[16]);
    }

    public static void doWOL(String ip, String mac) throws Exception {
        try (DatagramSocket ds = new DatagramSocket();){
            WakeOnLan.doWOL(ds, ip, mac);
        }
    }

    public static void doWOL(DatagramSocket ds, String ip, String mac) throws Exception {
        String ipStr = ip;
        String macStr = mac;
        InetAddress address = InetAddress.getByName(ipStr);
        byte[] addrBytes = address.getAddress();
        byte[] macBytes = WakeOnLan.getMacBytes(macStr);
        WakeOnLan.doWOL(ds, addrBytes, macBytes);
    }

    public static void doWOL(byte[] ipBytes, byte[] macBytes) throws Exception {
        try (DatagramSocket ds = new DatagramSocket();){
            WakeOnLan.doWOL(ds, ipBytes, macBytes);
        }
    }

    public static void doWOL(DatagramSocket socket, byte[] ipBytes, byte[] macBytes) throws Exception {
        int i;
        byte[] bytes = new byte[6 + 16 * macBytes.length];
        for (i = 0; i < 6; ++i) {
            bytes[i] = -1;
        }
        for (i = 6; i < bytes.length; i += macBytes.length) {
            System.arraycopy(macBytes, 0, bytes, i, macBytes.length);
        }
        InetAddress addr = InetAddress.getByAddress(ipBytes);
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, addr, 7);
        Thread.sleep((int)(Math.random() * 25.0));
        socket.send(packet);
        System.out.println("[WOL] WOL sent to " + addr);
        if (!WakeOnLan.isBroadcastIP(ipBytes)) {
            ipBytes[3] = -1;
            addr = InetAddress.getByAddress(ipBytes);
            packet = new DatagramPacket(bytes, bytes.length, addr, 7);
            Thread.sleep((int)(Math.random() * 25.0));
            socket.send(packet);
            System.out.println("[WOL] WOL sent to " + addr);
        }
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            List<InterfaceAddress> list = ni.getInterfaceAddresses();
            for (InterfaceAddress ia : list) {
                if (ia == null || (addr = ia.getBroadcast()) == null) continue;
                packet = new DatagramPacket(bytes, bytes.length, addr, 7);
                Thread.sleep((int)(Math.random() * 25.0));
                socket.send(packet);
                System.out.println("[WOL] WOL sent to " + addr + " (bcast addr from " + ni.getDisplayName() + ")");
            }
        }
    }

    public static byte[] getMacBytes(String macStr) throws IllegalArgumentException {
        byte[] bytes = new byte[6];
        String[] hex = macStr.split("(\\:|\\-)");
        if (hex.length != 6) {
            throw new IllegalArgumentException("Invalid MAC address.");
        }
        try {
            for (int i = 0; i < 6; ++i) {
                bytes[i] = (byte)Integer.parseInt(hex[i], 16);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid hex digit in MAC address.");
        }
        return bytes;
    }
}

