/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.jtree.checked;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import utils.swing.simplelist.jtree.SimpleTreeModel;
import utils.swing.simplelist.jtree.checked.CheckedNode;

public class CheckedRenderer
extends DefaultTreeCellRenderer {
    protected JPanel checkedPanel = new JPanel(new BorderLayout());
    protected JCheckBox box = new JCheckBox();

    public CheckedRenderer() {
        this.checkedPanel.add((Component)this.box, "West");
        this.checkedPanel.add((Component)this, "Center");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (sel) {
            this.box.setBackground(this.getBackgroundSelectionColor());
            this.checkedPanel.setBackground(this.getBackgroundSelectionColor());
        } else {
            this.box.setBackground(this.getBackgroundNonSelectionColor());
            this.checkedPanel.setBackground(this.getBackgroundNonSelectionColor());
        }
        if (value instanceof SimpleTreeModel.TreeNode) {
            value = ((SimpleTreeModel.TreeNode)value).value;
        }
        if (value instanceof CheckedNode && ((CheckedNode)value).showCheckBox()) {
            this.box.setSelected(((CheckedNode)value).isChecked());
            this.box.setVisible(true);
        } else {
            this.box.setVisible(false);
        }
        return this.checkedPanel;
    }
}

