/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.jtree.checked;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import utils.swing.simplelist.jtree.SimpleTreeModel;
import utils.swing.simplelist.jtree.checked.CheckedNode;

public class CheckNodeSelectionListener
extends MouseAdapter {
    protected JTree tree;

    public CheckNodeSelectionListener(JTree tree) {
        this.tree = tree;
    }

    protected void setChecked(CheckedNode node, boolean isChecked) {
        node.setChecked(isChecked);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int y;
        int x = e.getX();
        TreePath path = this.tree.getPathForLocation(x, y = e.getY());
        if (path != null && path.getLastPathComponent() instanceof SimpleTreeModel.TreeNode) {
            SimpleTreeModel.TreeNode lastPart = (SimpleTreeModel.TreeNode)path.getLastPathComponent();
            if (lastPart.value instanceof CheckedNode) {
                CheckedNode node = (CheckedNode)lastPart.value;
                int row = this.tree.getRowForLocation(x, y);
                Rectangle bounds = this.tree.getRowBounds(row);
                if (x < bounds.x || x > bounds.x + 20) {
                    return;
                }
                boolean isSelected = !node.isChecked();
                this.setChecked(node, isSelected);
                this.tree.repaint(bounds);
                if (row == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }
}

