/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.jtable;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import utils.swing.simplelist.wrapper.SortWrapper;

public class TableSorter<E> {
    private final SortWrapper<E> sortWrapper;
    private final JTable table;
    private final SmartComparator smartComparator;

    public TableSorter(JTable table, SortWrapper<E> sortWrapper, SmartComparator<E> comparator) {
        this.table = table;
        this.sortWrapper = sortWrapper;
        this.smartComparator = comparator;
        sortWrapper.setComparator(this.smartComparator);
        if (table != null) {
            table.getTableHeader().addMouseListener(new MouseHandler());
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        int lastColumn = 0;
        boolean ascending = true;

        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1) {
                if (column == this.lastColumn) {
                    this.ascending = !this.ascending;
                } else {
                    this.ascending = true;
                    this.lastColumn = column;
                }
                TableSorter.this.smartComparator.setSortState(this.lastColumn, this.ascending);
                TableSorter.this.sortWrapper.setComparator(TableSorter.this.smartComparator);
            }
        }
    }

    public static abstract class SmartComparator<T>
    implements Comparator<T> {
        protected boolean ascending;
        protected int column;

        @Override
        public abstract int compare(T var1, T var2);

        public void setSortState(int column, boolean ascending) {
            this.column = column;
            this.ascending = ascending;
        }
    }
}

