/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.renderers;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class AlignTableCellRendererWrapper
implements TableCellRenderer {
    private final TableCellRenderer renderer;
    private int globalAlign = -1;
    private int[] alignments;

    public AlignTableCellRendererWrapper(TableCellRenderer defaultRenderer, int globalAlign) {
        this.renderer = defaultRenderer;
        this.globalAlign = globalAlign;
    }

    public AlignTableCellRendererWrapper(TableCellRenderer defaultRenderer, int[] alignments) {
        this.renderer = defaultRenderer;
        this.alignments = alignments;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel c = (JLabel)this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.globalAlign != -1) {
            c.setHorizontalAlignment(this.globalAlign);
        } else if (this.alignments != null && this.alignments.length > column) {
            c.setHorizontalAlignment(this.alignments[column]);
        }
        return c;
    }
}

