/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.logview;

import java.util.ArrayList;
import utils.string.CharStack;
import utils.swing.logview.LogEntry;
import utils.swing.logview.LogFile;

public class CTShifter {
    private static final long ONE_SEC = 1000L;
    private static final long ONE_MIN = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_MONTH = 2678400000L;
    private static final long ONE_YEAR = 31536000000L;
    private static boolean DEBUG_RELATIVE_TIME = false;

    private static long pickRelativeTime(String line) {
        CharStack cs = new CharStack(line);
        cs.popUntil("(+");
        cs.popWhitespace();
        if (cs.isEmpty()) {
            if (DEBUG_RELATIVE_TIME) {
                System.out.println("Unable to pick relative time from (Marker not found) " + line);
            }
            if ((line = line.trim()).startsWith("+")) {
                try {
                    cs = new CharStack(line);
                    cs.popWhitespace();
                    cs.pop();
                    long relms = (long)cs.popNumber();
                    return relms;
                }
                catch (Exception x) {
                    return 0L;
                }
            }
            return 0L;
        }
        try {
            return (long)cs.popNumber();
        }
        catch (NumberFormatException x) {
            if (DEBUG_RELATIVE_TIME) {
                System.out.println("Unable to pick relative time from (NumFormat) " + line);
            }
            return 0L;
        }
    }

    public static void buildAndTimestamp(LogFile logfile) {
        System.out.println("Time shifting " + logfile);
        ArrayList<CentralTime> ctimes = new ArrayList<CentralTime>();
        ArrayList<LogEntry> lines = logfile.lines;
        for (int i = 0; i < lines.size(); ++i) {
            CentralTime ct;
            long cmillis;
            long secs;
            long mins;
            long hours;
            long days;
            long months;
            CharStack cs;
            LogEntry entry = lines.get(i);
            if (entry.value.startsWith("M5")) {
                try {
                    cs = new CharStack(entry.value);
                    cs.popUntilNumber();
                    months = (int)cs.popNumber();
                    cs.popUntilNumber();
                    days = (int)cs.popNumber();
                    cs.popUntilNumber();
                    hours = (int)cs.popNumber();
                    cs.popUntilNumber();
                    mins = (int)cs.popNumber();
                    cs.popUntilNumber();
                    secs = (int)cs.popNumber();
                    cmillis = months * 2678400000L + days * 86400000L + hours * 3600000L + mins * 60000L + secs * 1000L;
                    if (ctimes.size() < 10) {
                        System.out.println("Found Central time STDOUT marker: " + cmillis);
                        if (ctimes.size() == 9) {
                            System.out.println("Will not print for future CT markers");
                        }
                    }
                    ct = new CentralTime(i, cmillis);
                    ctimes.add(ct);
                }
                catch (Exception x) {
                    System.out.println("Failed to parse ctime from " + entry.value);
                    x.printStackTrace(System.out);
                }
                continue;
            }
            if (entry.value.indexOf("[CentralisedTime]") == -1 && entry.value.indexOf("centralised time is ") == -1 || entry.value.indexOf("Set stdout provider") != -1) continue;
            try {
                cs = new CharStack(entry.value);
                cs.popUntil("CentralisedTime]");
                if (cs.isEmpty()) {
                    cs = new CharStack(entry.value);
                    cs.popUntil("centralised time is ");
                }
                cs.popUntilNumber();
                months = (int)cs.popNumber();
                cs.popUntilNumber();
                days = (int)cs.popNumber();
                cs.popUntilNumber();
                hours = (int)cs.popNumber();
                cs.popUntilNumber();
                mins = (int)cs.popNumber();
                cs.popUntilNumber();
                secs = (int)cs.popNumber();
                cmillis = months * 2678400000L + days * 86400000L + hours * 3600000L + mins * 60000L + secs * 1000L;
                if (ctimes.size() < 10) {
                    System.out.println("Found Central time marker: " + cmillis);
                    if (ctimes.size() == 9) {
                        System.out.println("Will not print for future CT markers");
                    }
                }
                ct = new CentralTime(i, cmillis);
                ctimes.add(ct);
                continue;
            }
            catch (Exception x) {
                System.out.println("Failed to parse ctime from " + entry.value);
                x.printStackTrace(System.out);
            }
        }
        for (LogEntry entry : lines) {
            entry.time = -1L;
            entry.isCentralTime = ctimes.size() > 0;
        }
        int attempts = 0;
        if (ctimes.size() == 0) {
            int index = 0;
            System.out.println("No central time references found, will use log file start time");
            if (logfile.logFileStartTime != -1L) {
                System.out.println("Log file start time is " + logfile.logFileStartTime + " (at index 0)");
                for (int i = 0; i < lines.size(); ++i) {
                    LogEntry entry = lines.get(i);
                    String value = entry.value;
                    if (!value.startsWith("8")) continue;
                    CharStack cs = new CharStack(value);
                    String num = cs.popText(true);
                    num = num.substring(1);
                    try {
                        long T = logfile.logFileStartTime - logfile.logFileStartTime % 10000000L + Long.parseLong(num);
                        System.out.println("Altered log file start time based on cheap timing from " + logfile.logFileStartTime + " to " + T + " (" + (T - logfile.logFileStartTime) + ")");
                        index = i;
                        logfile.logFileStartTime = T;
                        System.out.println("Central Time " + logfile.logFileStartTime + " will map to CheapTiming " + num);
                    }
                    catch (Exception x) {
                        if (++attempts <= 10) continue;
                        System.out.println("Unable to pick cheap timing stream info to inform log start time - " + x);
                    }
                    break;
                }
                ctimes.add(new CentralTime(index, logfile.logFileStartTime));
            } else {
                System.out.println("Log file start time is not found! We have no timing reference points for this logfile!");
            }
        }
        boolean debugFirstEntry = false;
        boolean leModified = true;
        while (leModified) {
            leModified = false;
            for (int i = 0; i < ctimes.size(); ++i) {
                long relms;
                CentralTime ct = (CentralTime)ctimes.get(i);
                if (i == 0 && debugFirstEntry) {
                    System.out.println("CT " + ct.backIndex + " / " + ct.fwdIndex + " (" + ct.backTime + " / " + ct.fwdTime + ")");
                }
                if (ct.backIndex >= 0) {
                    LogEntry back = lines.get(ct.backIndex);
                    if (back.time == -1L) {
                        leModified = true;
                        back.time = ct.backTime;
                        relms = CTShifter.pickRelativeTime(lines.get((int)ct.backIndex).value);
                        if (i == 1 && debugFirstEntry) {
                            System.out.println("Back -= " + relms);
                        }
                        ct.backTime -= relms;
                        --ct.backIndex;
                    } else {
                        ct.backIndex = 0;
                    }
                }
                if (ct.fwdIndex == ct.backIndex + 1) {
                    ++ct.fwdIndex;
                    leModified = true;
                    if (ct.fwdIndex >= lines.size()) continue;
                    long relms2 = CTShifter.pickRelativeTime(lines.get((int)ct.fwdIndex).value);
                    if (i == 0 && debugFirstEntry) {
                        System.out.println("Fwd (" + ct.fwdIndex + ") += " + relms2);
                    }
                    ct.fwdTime += relms2;
                    continue;
                }
                if (ct.fwdIndex >= lines.size()) continue;
                LogEntry fwd = lines.get(ct.fwdIndex);
                if (fwd.time == -1L) {
                    leModified = true;
                    fwd.time = ct.fwdTime;
                    ++ct.fwdIndex;
                    if (ct.fwdIndex >= lines.size()) continue;
                    relms = CTShifter.pickRelativeTime(lines.get((int)ct.fwdIndex).value);
                    if (i == 0 && debugFirstEntry) {
                        System.out.println("Fwd (" + ct.fwdIndex + ") += " + relms);
                    }
                    ct.fwdTime += relms;
                    continue;
                }
                ct.fwdIndex = lines.size();
            }
        }
    }

    static class CentralTime {
        int backIndex;
        int fwdIndex;
        long backTime;
        long fwdTime;

        public CentralTime(int index, long cmillis) {
            this.backIndex = index;
            this.fwdIndex = index;
            this.backTime = cmillis;
            this.fwdTime = cmillis;
        }
    }
}

