/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UnsupportedLookAndFeelException;
import utils.swing.components.SHSplitPane;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHSplitPaneUI;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class HierarchyPanel {
    public static final int RESIZE_TYPE_NONE = 1;
    public static final int RESIZE_TYPE_LEFT = 1;
    public static final int RESIZE_TYPE_RIGHT = 2;
    public static final int RESIZE_TYPE_DIVIDER_CLICK_RIGHT = 3;
    public static final int RESIZE_TYPE_DIVIDER_CLICK_LEFT = 4;
    private final SplitPaneComponentListener leftComponentListener;
    private final SplitPaneComponentListener centreComponentListener;
    private GridLayout rootLayout = new GridLayout(1, 1){

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            int rootHeight = HierarchyPanel.this.rootComponent.getHeight();
            if (!HierarchyPanel.this.min && rootHeight > 0) {
                int buffer = ((HierarchyPanel)HierarchyPanel.this).detailsPanel.getMinimumSize().height + SimpleHelpLookAndFeel.scale((int)9);
                if (HierarchyPanel.this.centreSplit.getDividerLocation() > rootHeight - buffer) {
                    HierarchyPanel.this.setCentreDividerLocation(rootHeight - buffer, true);
                    HierarchyPanel.this.rootComponent.repaint();
                }
            }
        }
    };
    private JPanel rootComponent = new JPanel(this.rootLayout);
    private boolean min;
    private boolean max;
    private SHSplitPane leftSplit;
    private SHSplitPane centreSplit;
    private JPanel hierarchyPanel;
    private JPanel contentsPanel;
    private JPanel detailsPanel;
    private int previousLeftSplitLocation;
    private int previousCentreSplitLocation;
    private HierarchyResizeListener listener = null;
    private boolean notifyListener = true;
    private final PropertyChangeListener sliderChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            String propertyName = changeEvent.getPropertyName();
            if (propertyName.equals("lastDividerLocation")) {
                if (changeEvent.getSource() == HierarchyPanel.this.leftSplit) {
                    HierarchyPanel.this.notifyListenerOfSizeChange(1);
                } else {
                    HierarchyPanel.this.notifyListenerOfSizeChange(2);
                }
            }
        }
    };

    public void hierarchyResized(int leftSplitLocation, int centreSplitLocation, int resizeType) {
        if (centreSplitLocation > 0) {
            int unscaledLeft = SimpleHelpLookAndFeel.unscale((int)leftSplitLocation);
            int unscaledCentre = SimpleHelpLookAndFeel.unscale((int)centreSplitLocation);
            this.listener.saveHierarchyPosition(unscaledLeft, unscaledCentre, this.min, this.max, resizeType == 3);
        }
    }

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public HierarchyPanel() {
        this.initUI();
        this.leftComponentListener = new SplitPaneComponentListener(this.leftSplit, false);
        this.centreComponentListener = new SplitPaneComponentListener(this.centreSplit, true);
        this.leftSplit.addComponentListener(this.leftComponentListener);
        this.centreSplit.addComponentListener(this.centreComponentListener);
        if (this.leftSplit.getUI() instanceof SHSplitPaneUI) {
            ((SHSplitPaneUI)this.leftSplit.getUI()).setDividerMouseListener((MouseListener)this.leftComponentListener);
        }
        if (this.centreSplit.getUI() instanceof SHSplitPaneUI) {
            ((SHSplitPaneUI)this.centreSplit.getUI()).setDividerMouseListener((MouseListener)this.centreComponentListener);
        }
    }

    public HierarchyPanel(HierarchyResizeListener listener) {
        this();
        this.setHierarchyResizeListener(listener);
    }

    public void setHierarchyResizeListener(HierarchyResizeListener listener) {
        this.listener = listener;
    }

    private void notifyListenerOfSizeChange(int resizeType) {
        if (this.listener != null && this.notifyListener) {
            this.hierarchyResized(this.leftSplit.getDividerLocation(), this.centreSplit.getDividerLocation(), resizeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDividerLocations(int leftSplitLocation, int centreSplitLocation) {
        this.notifyListener = false;
        try {
            boolean changed;
            boolean bl = changed = this.leftSplit.getDividerLocation() != leftSplitLocation || this.centreSplit.getDividerLocation() != centreSplitLocation;
            if (changed) {
                this.leftSplit.setDividerLocation(leftSplitLocation);
                this.setCentreDividerLocation(centreSplitLocation, true);
                this.previousCentreSplitLocation = centreSplitLocation;
                this.previousLeftSplitLocation = leftSplitLocation;
                this.leftSplit.repaint();
            }
        }
        finally {
            this.notifyListener = true;
        }
    }

    public JPanel getHierarchyPanel() {
        return this.hierarchyPanel;
    }

    public JPanel getContentsPanel() {
        return this.contentsPanel;
    }

    public JPanel getDetailsPanel() {
        return this.detailsPanel;
    }

    private void setPanelVisibilities(final boolean hierarchy, final boolean contents, final boolean details) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HierarchyPanel.this.setPanelVisibilities(hierarchy, contents, details);
                }
            });
            return;
        }
        this.rootComponent.removeAll();
        if (hierarchy) {
            if (contents) {
                if (details) {
                    this.leftSplit.setLeftComponent(this.hierarchyPanel);
                    this.leftSplit.setRightComponent(this.centreSplit);
                    this.centreSplit.setLeftComponent(this.contentsPanel);
                    this.centreSplit.setRightComponent(this.detailsPanel);
                    this.fixMovingDivider(this.leftSplit);
                    this.fixMovingDivider(this.centreSplit);
                    this.rootComponent.add(this.leftSplit);
                } else {
                    this.leftSplit.setLeftComponent(this.hierarchyPanel);
                    this.leftSplit.setRightComponent(this.contentsPanel);
                    this.fixMovingDivider(this.leftSplit);
                    this.rootComponent.add(this.leftSplit);
                }
            } else if (details) {
                this.leftSplit.setLeftComponent(this.hierarchyPanel);
                this.leftSplit.setRightComponent(this.detailsPanel);
                this.fixMovingDivider(this.leftSplit);
                this.rootComponent.add(this.leftSplit);
            } else {
                this.rootComponent.add(this.hierarchyPanel);
            }
        } else if (contents) {
            if (details) {
                this.centreSplit.setLeftComponent(this.contentsPanel);
                this.centreSplit.setRightComponent(this.detailsPanel);
                this.fixMovingDivider(this.centreSplit);
                this.rootComponent.add(this.centreSplit);
            } else {
                this.rootComponent.add(this.contentsPanel);
            }
        } else if (details) {
            this.rootComponent.add(this.detailsPanel);
        }
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    private void fixMovingDivider(SHSplitPane split) {
        int prev = split.getDividerLocation();
        split.revalidate();
        split.layout();
        if (prev != -1) {
            split.setDividerLocation(prev);
        }
    }

    private void setCentreDividerLocation(int newLocation, boolean overwritePreviousCentreSplitLocation) {
        int topBuffer = SimpleHelpLookAndFeel.scale((int)150);
        int rootSize = this.getRootComponent().getHeight();
        int bottomBuffer = this.detailsPanel.getMinimumSize().height + SimpleHelpLookAndFeel.scale((int)7);
        if (newLocation < topBuffer) {
            newLocation = topBuffer;
        } else if (rootSize > 0 && !this.min && this.centreSplit.getDividerLocation() > rootSize - bottomBuffer) {
            newLocation = this.getRootComponent().getHeight() - bottomBuffer;
        }
        if (overwritePreviousCentreSplitLocation) {
            this.previousCentreSplitLocation = newLocation;
        }
        this.centreSplit.setDividerLocation(newLocation);
    }

    public void setDetailsPanelVisible(boolean visible) {
        boolean splitWasVisible = this.detailsPanel.isVisible() && this.contentsPanel.isVisible();
        this.detailsPanel.setVisible(visible);
        boolean splitIsVisible = this.detailsPanel.isVisible() && this.contentsPanel.isVisible();
        int newLocation = -1;
        if (splitWasVisible && !splitIsVisible) {
            this.previousCentreSplitLocation = this.centreSplit.getDividerLocation();
        } else if (!splitWasVisible && splitIsVisible) {
            newLocation = this.previousCentreSplitLocation;
        }
        if (splitIsVisible && newLocation > -1) {
            this.setCentreDividerLocation(newLocation, true);
        }
        this.setPanelVisibilities(this.hierarchyPanel.isVisible(), this.contentsPanel.isVisible(), this.detailsPanel.isVisible());
    }

    public void setContentsPanelVisible(boolean visible) {
        boolean splitIsVisible;
        boolean splitWasVisible = this.detailsPanel.isVisible() && this.contentsPanel.isVisible();
        this.contentsPanel.setVisible(visible);
        boolean bl = splitIsVisible = this.detailsPanel.isVisible() && this.contentsPanel.isVisible();
        if (splitWasVisible && !splitIsVisible) {
            this.previousCentreSplitLocation = this.centreSplit.getDividerLocation();
        }
        if (!splitWasVisible && splitIsVisible) {
            this.setCentreDividerLocation(this.previousCentreSplitLocation, true);
        }
        this.setPanelVisibilities(this.hierarchyPanel.isVisible(), this.contentsPanel.isVisible(), this.detailsPanel.isVisible());
    }

    public void setHierarchyPanelVisible(boolean visible) {
        if (this.hierarchyPanel.isVisible() == visible) {
            return;
        }
        this.hierarchyPanel.setVisible(visible);
        if (!visible) {
            this.previousLeftSplitLocation = this.leftSplit.getDividerLocation();
        } else {
            this.leftSplit.setDividerLocation(this.previousLeftSplitLocation);
        }
        this.setPanelVisibilities(this.hierarchyPanel.isVisible(), this.contentsPanel.isVisible(), this.detailsPanel.isVisible());
    }

    private void initUI() {
        this.contentsPanel = new JPanel();
        this.detailsPanel = new JPanel();
        this.hierarchyPanel = new JPanel();
        this.centreSplit = new SHSplitPane(0);
        this.centreSplit.setDividerLocation(0.7);
        this.centreSplit.setLeftComponent(this.contentsPanel);
        this.centreSplit.setRightComponent(this.detailsPanel);
        this.centreSplit.setBorder(null);
        this.centreSplit.setResizeWeight(1.0);
        this.centreSplit.setOneTouchExpandable(false);
        this.centreSplit.setContinuousLayout(true);
        this.leftSplit = new SHSplitPane(1);
        this.leftSplit.setDividerLocation(0.3);
        this.leftSplit.setLeftComponent(this.hierarchyPanel);
        this.leftSplit.setRightComponent(this.centreSplit);
        this.leftSplit.setBorder(null);
        this.leftSplit.setResizeWeight(0.0);
        this.leftSplit.setOneTouchExpandable(false);
        this.leftSplit.setContinuousLayout(true);
        this.leftSplit.addPropertyChangeListener(this.sliderChangeListener);
        this.centreSplit.addPropertyChangeListener(this.sliderChangeListener);
        this.setPanelVisibilities(true, true, true);
    }

    public void setDetailsPanelState(boolean min, boolean max, int minHeight) {
        if (this.max == max && this.min == min) {
            return;
        }
        this.min = min;
        this.max = max;
        this.centreComponentListener.setActive(!max && !min);
        if (max) {
            this.setContentsPanelVisible(false);
        } else {
            this.setContentsPanelVisible(true);
        }
        if (min) {
            this.previousCentreSplitLocation = this.centreSplit.getDividerLocation();
            this.centreSplit.setDividerLocation(this.centreSplit.getHeight() - minHeight);
            this.centreSplit.setResizeWeight(1.0);
            this.detailsPanel.setMaximumSize(new Dimension(0, minHeight));
            this.detailsPanel.setPreferredSize(new Dimension(0, minHeight));
        } else {
            this.detailsPanel.setMaximumSize(null);
            this.detailsPanel.setPreferredSize(null);
            if (!this.centreComponentListener.resizing) {
                this.centreSplit.setDividerLocation(this.previousCentreSplitLocation);
            }
            this.centreSplit.setResizeWeight(0.0);
        }
        this.hierarchyResized(this.leftSplit.getDividerLocation(), this.centreSplit.getDividerLocation(), 1);
    }

    public void setDetailsPanelMinimumHeight(int minHeight) {
        this.detailsPanel.setMinimumSize(new Dimension(0, minHeight - SimpleHelpLookAndFeel.scale((int)7)));
    }

    public static void main(String[] args) throws InterruptedException, UnsupportedLookAndFeelException, InvocationTargetException {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        HierarchyPanel hp = new HierarchyPanel();
        hp.contentsPanel.setBorder(SHBorderFactory.createLineBorder((Color)Color.red));
        hp.contentsPanel.setBackground(new Color(255, 220, 220));
        hp.detailsPanel.setBackground(new Color(220, 255, 220));
        hp.detailsPanel.setBorder(SHBorderFactory.createLineBorder((Color)Color.green));
        hp.hierarchyPanel.setBackground(new Color(220, 220, 255));
        hp.hierarchyPanel.setBorder(SHBorderFactory.createLineBorder((Color)Color.blue));
        frame.getContentPane().add(hp.getRootComponent());
        SwingUtilities.invokeAndWait(new Runnable((JFrame)frame){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void run() {
                this.val$frame.setVisible(true);
                this.val$frame.repaint();
            }
        });
    }

    public boolean isDetailsPanelVisible() {
        return this.detailsPanel.isVisible();
    }

    public static interface HierarchyResizeListener {
        public void saveHierarchyPosition(int var1, int var2, boolean var3, boolean var4, boolean var5);
    }

    private class SplitPaneComponentListener
    extends ComponentAdapter
    implements MouseListener {
        private final boolean favourRight;
        private int previousLength = -1;
        private int targetLength = -1;
        private JSplitPane pane;
        private boolean active = true;
        private boolean resizing;

        public SplitPaneComponentListener(JSplitPane pane, boolean favourRight) {
            this.pane = pane;
            this.favourRight = favourRight;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (!this.active) {
                return;
            }
            Component left = this.pane.getLeftComponent();
            Component right = this.pane.getRightComponent();
            int newLength = this.favourRight ? right.getSize().height : left.getSize().width;
            if (this.previousLength != -1) {
                if (this.previousLength > newLength && this.targetLength == -1) {
                    this.targetLength = this.previousLength;
                    if (this.favourRight) {
                        this.pane.setResizeWeight(0.0);
                    } else {
                        this.pane.setResizeWeight(1.0);
                    }
                } else if (this.previousLength < newLength && newLength >= this.targetLength) {
                    if (this.favourRight) {
                        this.pane.setResizeWeight(1.0);
                    } else {
                        this.pane.setResizeWeight(0.0);
                    }
                    this.targetLength = -1;
                }
            }
            this.previousLength = newLength;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.resizing = true;
            if (this.pane == HierarchyPanel.this.centreSplit) {
                HierarchyPanel.this.setDetailsPanelState(false, false, 0);
            }
            HierarchyPanel.this.notifyListenerOfSizeChange(this.pane == HierarchyPanel.this.leftSplit ? 4 : 3);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.resizing = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }
}

