/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons.colorproviders;

import java.awt.Color;
import utils.swing.icons.colorproviders.StaticColorProvider;

public class TwoHueColourProvider
extends StaticColorProvider {
    private final Color min;
    private final Color middle;
    private final Color max;

    public TwoHueColourProvider(Color min, Color middle, Color max) {
        this.min = min;
        this.middle = middle;
        this.max = max;
    }

    public TwoHueColourProvider(Color min, Color max) {
        this.min = min;
        this.max = max;
        this.middle = new Color(min.getRed() + (max.getRed() - min.getRed()) / 2, min.getGreen() + (max.getGreen() - min.getGreen()) / 2, min.getBlue() + (max.getBlue() - min.getBlue()) / 2);
    }

    protected Color produceNextColor() {
        return this.nextColor(true);
    }

    protected Color produceNextBackgroundColor() {
        return this.nextColor(false);
    }

    protected Color nextColor(boolean up) {
        Color right;
        Color left;
        double rand = Math.random();
        if (up) {
            left = this.middle;
            right = this.max;
        } else {
            left = this.min;
            right = this.middle;
        }
        int diffR = right.getRed() - left.getRed();
        int diffG = right.getGreen() - left.getGreen();
        int diffB = right.getBlue() - left.getBlue();
        return new Color((int)((double)left.getRed() + (double)diffR * rand), (int)((double)left.getGreen() + (double)diffG * rand), (int)((double)left.getBlue() + (double)diffB * rand));
    }
}

