/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.formatters;

import java.text.DecimalFormat;

public class DataSizeFormatter {
    public static final DataSizeFormatter INSTANCE = new DataSizeFormatter();
    private static final double SIZE_KB = 1000.0;
    private static final double SIZE_MB = 1000000.0;
    private static final double SIZE_GB = 1.0E9;
    private static final double SIZE_TB = 1.0E12;
    private static final double SIZE_PB = 1.0E15;
    private static final DecimalFormat df1 = new DecimalFormat("###,###,###,###,###,###,###,##0.#");
    private static final DecimalFormat df0 = new DecimalFormat("###,###,###,###,###,###,###,##0");

    private DataSizeFormatter() {
    }

    public String getFormattedSize(long bytes) {
        if ((double)bytes > 1.0E16) {
            return df0.format((double)bytes / 1.0E15) + " PB";
        }
        if ((double)bytes > 1.0E15) {
            return df1.format((double)bytes / 1.0E15) + " PB";
        }
        if ((double)bytes > 1.0E13) {
            return df0.format((double)bytes / 1.0E12) + " TB";
        }
        if ((double)bytes > 1.0E12) {
            return df1.format((double)bytes / 1.0E12) + " TB";
        }
        if ((double)bytes > 1.0E10) {
            return df0.format((double)bytes / 1.0E9) + " GB";
        }
        if ((double)bytes > 1.0E9) {
            return df1.format((double)bytes / 1.0E9) + " GB";
        }
        if ((double)bytes > 1.0E7) {
            return df0.format((double)bytes / 1000000.0) + " MB";
        }
        if ((double)bytes > 1000000.0) {
            return df1.format((double)bytes / 1000000.0) + " MB";
        }
        if ((double)bytes > 10000.0) {
            return df0.format((double)bytes / 1000.0) + " KB";
        }
        if ((double)bytes > 1000.0) {
            return df1.format((double)bytes / 1000.0) + " KB";
        }
        return bytes + " B";
    }
}

