/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.glassdialog;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.RootPaneContainer;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.layout.GbPanel;

public class ProgressGlassDialog {
    private final AbstractGlassDialog dialog;
    private final OKCancelDialogPanel dialogPanel;
    private JProgressBar bar;

    public ProgressGlassDialog(RootPaneContainer rootp, String message, String title, int max, String cancel) {
        if (cancel == null) {
            cancel = "X";
        }
        this.bar = new JProgressBar(0, Math.max(max, 1));
        if (max == -1) {
            this.bar.setIndeterminate(true);
        }
        GbPanel progressBarPanel = new GbPanel(new ScaledInsets(5, 0, 5, 0));
        progressBarPanel.add((Component)new JLabel(message), 0, 0, 1, 1, 100, 100, 17, 0);
        progressBarPanel.add((Component)this.bar, 0, 1, 1, 1, 100, 100, 10, 2);
        FixedWidthPanel contentPanel = new FixedWidthPanel((JComponent)progressBarPanel);
        this.dialogPanel = new OKCancelDialogPanel(cancel);
        this.dialogPanel.setContent((FixedWidthComponent)contentPanel);
        this.dialog = new AbstractGlassDialog(rootp, 400, (AbstractDialogPanel)this.dialogPanel);
        this.dialog.setTitle(title);
        this.dialog.setShowDecoration(true);
    }

    public ProgressGlassDialog(RootPaneContainer rootp, String message, String title, String cancel) {
        this(rootp, message, title, -1, cancel);
    }

    public void failed() {
        this.dialog.cancelPressed();
    }

    public void setValue(int val) {
        this.bar.setValue(val);
    }

    public int getMax() {
        return this.bar.getMaximum();
    }

    public void complete() {
        this.bar.setValue(this.bar.getMaximum());
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dialog.setVisible(false);
    }

    public boolean showNoBlock() {
        return this.show(false);
    }

    public boolean show() {
        return this.show(true);
    }

    public boolean show(boolean block) {
        this.dialog.showDialog(block);
        return this.dialogPanel.isOK();
    }

    public static void main(String[] args) throws Exception {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        ProgressGlassDialog.createTestDialog((JFrame)frame);
        System.exit(0);
    }

    public static void createTestDialog(JFrame frame) {
        ProgressGlassDialog dialog = new ProgressGlassDialog(frame, "Please Wait", "Please Wait", 10, "Forget it");
        new Test(dialog).start();
        if (dialog.show()) {
            System.out.println("Cancelled");
        } else {
            System.out.println("Done");
        }
    }

    static class Test
    extends Thread {
        ProgressGlassDialog pd;

        public Test(ProgressGlassDialog pd) {
            this.pd = pd;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 10; ++i) {
                    this.pd.setValue(i);
                    Thread.sleep(200L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pd.complete();
        }
    }
}

