/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.components.SHComboBox;
import utils.swing.components.messagefields.MessageTextField;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.LabelField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.CheckBoxField;
import utils.swing.cui.types.fields.ComboBoxField;
import utils.swing.cui.types.fields.RadioButtonField;
import utils.swing.cui.types.fields.TextAreaField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.cui.ui.CheckBoxConfigUI;
import utils.swing.cui.ui.ComboBoxConfigUI;
import utils.swing.cui.ui.ConfigUI;
import utils.swing.cui.ui.RadioButtonsConfigUI;
import utils.swing.cui.ui.TextAreaConfigUI;
import utils.swing.cui.ui.TextFieldConfigUI;
import utils.swing.cui.ui.WidthSlider;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class FieldCreator
extends MouseAdapter
implements KeyListener {
    private GbPanel panel = new GbPanel();
    private MessageTextField labelField;
    private SHComboBox fieldTypeList;
    private JLabel deleteLabel;
    private JLabel expandLabel;
    private JLabel blockFiller;
    private JLabel up;
    private JLabel down;
    private GbPanel configurablePanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private ResourceBundle bundle;
    private String[] typeOptions;
    private SwingStyleInterface style;
    boolean isExpanded = false;
    private ConfigUI configUI;
    private AbstractField.ChangeListener listener;
    ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FieldCreator.this.fieldTypeList) {
                FieldCreator.this.updateUIForNewType();
                if (FieldCreator.this.listener != null) {
                    FieldCreator.this.listener.changed(null);
                }
            }
        }
    };
    private ReorderingListener reorderingListener;
    private WidthSlider widthSlider;

    public GbPanel getRootComponent() {
        return this.panel;
    }

    public FieldCreator(ResourceBundle bundle, SwingStyleInterface style, boolean allowReordering) {
        this(bundle, style, allowReordering, null);
    }

    public FieldCreator(ResourceBundle bundle, SwingStyleInterface style, boolean allowReordering, AbstractField.ChangeListener listener) {
        this.listener = listener;
        this.bundle = bundle;
        this.style = style;
        this.initAbstractUI(allowReordering);
    }

    public CUIField generateUIType() {
        int selectedType = this.fieldTypeList.getSelectedIndex();
        Object type = null;
        switch (selectedType) {
            case 0: {
                type = new LabelField(this.labelField.getText());
                break;
            }
            case 1: {
                type = new TextField(this.labelField.getText(), this.listener);
                break;
            }
            case 2: {
                type = new TextAreaField(this.labelField.getText(), this.listener);
                break;
            }
            case 3: {
                type = new CheckBoxField(this.labelField.getText(), this.listener);
                break;
            }
            case 4: {
                type = new ComboBoxField(this.labelField.getText(), this.listener);
                break;
            }
            case 5: {
                type = new RadioButtonField(this.labelField.getText(), this.listener);
            }
        }
        if (type != null && this.configUI != null) {
            this.configUI.saveConfigurationTo((CUIField)type);
        }
        if (type instanceof AbstractField) {
            ((AbstractField)type).setWidthPercentage(this.widthSlider.getValuePercentage());
        }
        return type;
    }

    public void loadFrom(CUIField field) {
        this.labelField.setText(field.getLabel());
        if (field instanceof LabelField) {
            this.fieldTypeList.setSelectedIndex(0);
        } else if (field instanceof TextField) {
            this.fieldTypeList.setSelectedIndex(1);
        } else if (field instanceof TextAreaField) {
            this.fieldTypeList.setSelectedIndex(2);
        } else if (field instanceof CheckBoxField) {
            this.fieldTypeList.setSelectedIndex(3);
        } else if (field instanceof ComboBoxField) {
            this.fieldTypeList.setSelectedIndex(4);
        } else if (field instanceof RadioButtonField) {
            this.fieldTypeList.setSelectedIndex(5);
        }
        this.updateUIForNewType();
        if (this.configUI != null) {
            this.configUI.loadConfigurationFrom(field);
        }
        if (field instanceof AbstractField) {
            this.widthSlider.setValuePercentage(((AbstractField)field).getWidthPercentage());
        }
    }

    protected void updateUIForNewType() {
        this.configurablePanel.removeAll();
        int selectedType = this.fieldTypeList.getSelectedIndex();
        this.widthSlider.getRootComponent().setVisible(selectedType != 0);
        switch (selectedType) {
            case 0: {
                this.configUI = null;
                this.expandLabel.setVisible(false);
                this.blockFiller.setVisible(true);
                break;
            }
            case 1: {
                this.configUI = new TextFieldConfigUI(this.bundle, this.style, this.listener);
                this.configurablePanel.add((Component)this.configUI.getRootComponent(), 0, 1, 1, 1, 1, 1, 10, 2);
                this.expandLabel.setVisible(true);
                this.blockFiller.setVisible(false);
                break;
            }
            case 2: {
                this.configUI = new TextAreaConfigUI(this.bundle, this.style, this.listener);
                this.configurablePanel.add((Component)this.configUI.getRootComponent(), 0, 1, 1, 1, 1, 1, 10, 2);
                this.expandLabel.setVisible(true);
                this.blockFiller.setVisible(false);
                break;
            }
            case 3: {
                this.configUI = new CheckBoxConfigUI(this.bundle, this.style, this.listener);
                this.configurablePanel.add((Component)this.configUI.getRootComponent(), 0, 1, 1, 1, 1, 1, 10, 2);
                this.expandLabel.setVisible(true);
                this.blockFiller.setVisible(false);
                break;
            }
            case 4: {
                this.configUI = new ComboBoxConfigUI(this.bundle, this.style, this.listener);
                this.configurablePanel.add((Component)this.configUI.getRootComponent(), 0, 1, 1, 1, 1, 1, 10, 2);
                this.expandLabel.setVisible(true);
                this.blockFiller.setVisible(false);
                break;
            }
            case 5: {
                this.configUI = new RadioButtonsConfigUI(this.bundle, this.style, this.listener);
                this.configurablePanel.add((Component)this.configUI.getRootComponent(), 0, 1, 1, 1, 1, 1, 10, 2);
                this.expandLabel.setVisible(true);
                this.blockFiller.setVisible(false);
            }
        }
        this.configurablePanel.revalidate();
    }

    public void setReorderingButtonsEnabled(boolean canGoUp, boolean canGoDown) {
        if (this.up != null) {
            if (canGoUp) {
                this.up.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/up.svg,10"));
            } else {
                this.up.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/arrows/up.svg,10"));
            }
        }
        if (this.down != null) {
            if (canGoDown) {
                this.down.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/down.svg,10"));
            } else {
                this.down.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/arrows/down.svg,10"));
            }
        }
    }

    public void initAbstractUI(boolean allowReordering) {
        JLabel labelLabel = new JLabel(this.bundle.getString("CUI_LABEL"));
        this.labelField = new MessageTextField(this.bundle.getString("CUI_LABEL_MESSAGE"), null);
        this.labelField.addKeyListener((KeyListener)this);
        this.widthSlider = new WidthSlider(this.bundle, this.style, this.listener);
        this.widthSlider.getRootComponent().setVisible(false);
        this.typeOptions = new String[]{this.bundle.getString("CUI_TYPE_LABEL"), this.bundle.getString("CUI_TYPE_TEXT"), this.bundle.getString("CUI_TYPE_TEXTAREA"), this.bundle.getString("CUI_TYPE_CHECKBOX"), this.bundle.getString("CUI_TYPE_COMBOBOX"), this.bundle.getString("CUI_TYPE_RADIOBUTTONS")};
        final Icon[] icons = new Icon[]{ImageLoader.getImageIcon((String)"images/png/components/label.png"), ImageLoader.getImageIcon((String)"images/png/components/textfield.png"), ImageLoader.getImageIcon((String)"images/png/components/textarea.png"), ImageLoader.getImageIcon((String)"images/png/components/checkbox.png"), ImageLoader.getImageIcon((String)"images/png/components/combobox.png"), ImageLoader.getImageIcon((String)"images/png/components/radiobuttons.png")};
        JLabel typeLabel = new JLabel(this.bundle.getString("CUI_TYPE"));
        this.fieldTypeList = new SHComboBox((Object[])this.typeOptions);
        this.fieldTypeList.setIconInterface(new SHComboBox.IconInterface(){

            public Icon getIconFor(int row) {
                return icons[row];
            }
        });
        this.fieldTypeList.addActionListener(this.actionListener);
        SwingUtil.setWidth((JComponent)this.labelField, (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setWidth((JComponent)this.fieldTypeList, (int)SimpleHelpLookAndFeel.scale((int)200));
        GbPanel upDownButtons = null;
        if (allowReordering) {
            upDownButtons = new GbPanel();
            this.up = new JLabel(ImageLoader.getImageIcon((String)"images/svg/arrows/up.svg,10"));
            this.down = new JLabel(ImageLoader.getImageIcon((String)"images/svg/arrows/down.svg,10"));
            this.up.setBorder(SHBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
            this.down.setBorder(SHBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
            this.up.addMouseListener(this);
            this.down.addMouseListener(this);
            upDownButtons.add((Component)this.up, 0, 0, 1, 1, 0, 0, 10, 0);
            upDownButtons.add((Component)this.down, 0, 1, 1, 1, 0, 0, 10, 0);
        }
        this.expandLabel = new JLabel(this.style.getImageIcon("images/svg/arrows/expand-down.svg,16"));
        this.expandLabel.addMouseListener(this);
        this.expandLabel.setVisible(false);
        this.blockFiller = new JLabel();
        this.blockFiller.setMinimumSize(this.expandLabel.getPreferredSize());
        this.blockFiller.setPreferredSize(this.expandLabel.getPreferredSize());
        this.deleteLabel = new JLabel(this.style.getDisabledImageIcon("images/svg/general/remove.svg,16"));
        this.deleteLabel.addMouseListener(this);
        SwingUtil.setHeight((JComponent)this.deleteLabel, (int)this.widthSlider.getRootComponent().getPreferredSize().height);
        GbPanel headerPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        int X = 0;
        int Y = 0;
        headerPanel.add((Component)labelLabel, X++, Y, 1, 1, 0, 1, 13, 0);
        headerPanel.add((Component)this.labelField, X++, Y, 1, 1, 1, 1, 17, 0);
        headerPanel.add((Component)typeLabel, X++, Y, 1, 1, 0, 1, 13, 0);
        headerPanel.add((Component)this.fieldTypeList, X++, Y, 1, 1, 1, 1, 17, 0);
        if (allowReordering) {
            headerPanel.add((Component)upDownButtons, X++, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 10, 3, 10));
        }
        headerPanel.add((Component)this.expandLabel, X++, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        headerPanel.add((Component)this.blockFiller, X++, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        headerPanel.add((Component)this.widthSlider.getRootComponent(), X++, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 10, 3, 3));
        headerPanel.add((Component)this.deleteLabel, X++, Y++, 1, 1, 1000, 1, 13, 0);
        Y = 0;
        this.panel.add((Component)headerPanel, 0, Y++, 1, 1, 100, 1, 17, 2);
        this.panel.add((Component)this.configurablePanel, 0, Y++, 1, 1, 100, 1, 10, 2);
        this.configurablePanel.setVisible(false);
        this.panel.addMouseListener((MouseListener)this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.deleteLabel) {
            this.reorderingListener.delete(this);
            this.listener.changed(null);
        } else if (e.getSource() == this.expandLabel) {
            if (this.isExpanded) {
                this.expandLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/expand-down.svg,16"));
                this.configurablePanel.setVisible(false);
            } else {
                this.expandLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/expand-up.svg,16"));
                this.configurablePanel.setVisible(true);
            }
            this.expandLabel.repaint();
            this.isExpanded = !this.isExpanded;
        } else if (e.getSource() == this.up) {
            this.reorderingListener.moveUp(this);
            this.listener.changed(null);
        } else if (e.getSource() == this.down) {
            this.reorderingListener.moveDown(this);
            this.listener.changed(null);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.deleteLabel) {
            this.deleteLabel.setIcon(this.style.getImageIcon("images/svg/general/remove.svg,16"));
            this.deleteLabel.setCursor(Cursor.getPredefinedCursor(12));
        } else if (e.getSource() == this.expandLabel) {
            this.expandLabel.setCursor(Cursor.getPredefinedCursor(12));
        } else if (e.getSource() == this.up) {
            this.up.setCursor(Cursor.getPredefinedCursor(12));
        } else if (e.getSource() == this.down) {
            this.down.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this.deleteLabel) {
            this.deleteLabel.setIcon(this.style.getDisabledImageIcon("images/svg/general/remove.svg,16"));
            this.deleteLabel.setCursor(Cursor.getPredefinedCursor(0));
        } else if (e.getSource() == this.expandLabel) {
            this.expandLabel.setCursor(Cursor.getPredefinedCursor(0));
        } else if (e.getSource() == this.up) {
            this.up.setCursor(Cursor.getPredefinedCursor(0));
        } else if (e.getSource() == this.down) {
            this.down.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FieldCreator.this.labelField.requestFocusInWindow();
            }
        });
    }

    public void setReorderingListener(ReorderingListener listener) {
        this.reorderingListener = listener;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.listener != null) {
            this.listener.changed(null);
        }
    }

    public void setDeleteEnabled(boolean isEnabled) {
        this.deleteLabel.setEnabled(isEnabled);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FieldCreator.this.deleteLabel.repaint();
            }
        });
    }

    static interface ReorderingListener {
        public void delete(FieldCreator var1);

        public void moveUp(FieldCreator var1);

        public void moveDown(FieldCreator var1);
    }
}

