/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types.fields;

import java.awt.GridLayout;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Element;
import utils.swing.components.messagefields.MessageTextArea;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.validators.RequiredValidator;
import utils.swing.cui.validators.Validator;
import utils.swing.customlaf.SHBorderFactory;
import utils.xml.XML14Util;

public class TextAreaField
extends AbstractField {
    public static final String TEXTAREAFIELD_TYPE = "textarea";
    public static final int DEFAULT_ROWS = 5;
    private MessageTextArea textArea;
    private JScrollPane pane;
    private String exampleValue;
    private String defaultValue;
    private boolean isRequired = false;
    private int rowCount = 5;

    public String getExampleValue() {
        return this.exampleValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public TextAreaField(String label, AbstractField.ChangeListener changeListener) {
        super(TEXTAREAFIELD_TYPE, label, changeListener);
        this.textArea.addKeyListener((KeyListener)this.proxyChangeListener);
    }

    protected void initComponent() {
        this.textArea = new MessageTextArea(null, null);
        this.textArea.setTabSize(3);
        JPanel wrapperPanel = new JPanel(new GridLayout(1, 1));
        wrapperPanel.setBackground(this.textArea.getBackground());
        wrapperPanel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        wrapperPanel.add(this.textArea);
        this.pane = new JScrollPane(wrapperPanel);
    }

    public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
        return new ResultPair(this.label, this.textArea.getText());
    }

    public ResultPair getStorableFilledOutData() {
        return new ResultPair(this.label, this.textArea.getText());
    }

    public void setStorableFilledOutData(ResultPair data) {
        this.textArea.setText(data.getValue());
    }

    public void setRowCount(int count) {
        this.rowCount = count;
        this.textArea.setRows(this.rowCount);
    }

    public JComponent getComponent() {
        return this.pane;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public void setExampleValue(String exampleValue) {
        this.exampleValue = exampleValue;
        this.textArea.setMessageText(exampleValue);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        if (defaultValue != null) {
            this.textArea.setText(defaultValue);
        } else {
            this.textArea.clear();
        }
    }

    public static CUIField fromXML(Element element, AbstractField.ChangeListener cl) {
        String rowString;
        String label = element.getAttribute("label");
        TextAreaField type = new TextAreaField(label, cl);
        type.setDefaultValue(XML14Util.getChildText((Element)element, (String)"Default", null));
        type.setExampleValue(XML14Util.getChildText((Element)element, (String)"Example", null));
        if (XML14Util.getChildText((Element)element, (String)"Required", null) != null) {
            type.setRequired(true);
        }
        if ((rowString = XML14Util.getChildText((Element)element, (String)"RowCount", null)) != null && rowString.length() > 0) {
            type.setRowCount(Integer.parseInt(rowString));
        }
        return type;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        if (isRequired) {
            this.addValidator((Validator)new RequiredValidator(isRequired));
        }
    }

    public void toXML(StringBuffer buffer, int tabs) {
        if (this.defaultValue != null) {
            buffer.append(XML14Util.getIndent((int)tabs)).append("<Default>" + this.defaultValue + "</Default>\n");
        }
        if (this.exampleValue != null) {
            buffer.append(XML14Util.getIndent((int)tabs)).append("<Example>" + this.exampleValue + "</Example>\n");
        }
        if (this.isRequired) {
            buffer.append(XML14Util.getIndent((int)tabs)).append("<Required>" + Boolean.toString(true) + "</Required>\n");
        }
        buffer.append(XML14Util.getIndent((int)tabs)).append("<RowCount>" + this.rowCount + "</RowCount>\n");
    }

    public void clearContents() {
        this.textArea.clear();
    }
}

