/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types.fields;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.w3c.dom.Element;
import utils.ostools.OSDirs;
import utils.swing.SafeJFileChooser;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.layout.GbPanel;
import utils.xml.XML14Util;

public class FileChooserField
extends AbstractField {
    public static final String FILECHOOSER_TYPE = "filechooser";
    private static final boolean USE_FILEDIALOG = true;
    private GbPanel chooserUI;
    private JLabel fileChoice;
    private JButton chooseButton;
    private String defaultValue = null;
    private boolean directoryOnly = false;
    private String buttonLabel;

    public FileChooserField(String label, AbstractField.ChangeListener changeListener, String buttonLabel) {
        super(FILECHOOSER_TYPE, label, changeListener);
        this.initUI(buttonLabel);
    }

    public void setTransientButtonImage(Icon icon) {
        this.chooseButton.setIcon(icon);
    }

    public void setBackground(Color backgroundColor) {
        super.setBackground(backgroundColor);
        this.chooserUI.setBackground(backgroundColor);
    }

    public void setDefaultFile(String defaultValue) {
        this.defaultValue = defaultValue;
        this.clearContents();
    }

    public void setDirectoryOnly(boolean directoryOnly) {
        this.directoryOnly = directoryOnly;
    }

    public void toXML(StringBuffer buffer, int tabs) {
        if (this.defaultValue != null) {
            buffer.append(XML14Util.getIndent((int)tabs)).append("<Default>" + this.defaultValue + "</Default>\n");
        }
        if (this.buttonLabel != null) {
            buffer.append(XML14Util.getIndent((int)tabs)).append("<ButtonLabel>" + this.buttonLabel + "</ButtonLabel>\n");
        }
        if (this.directoryOnly) {
            buffer.append(XML14Util.getIndent((int)tabs)).append("<DirectoryOnly>" + Boolean.toString(this.directoryOnly) + "</DirectoryOnly>\n");
        }
    }

    public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
        return new ResultPair(this.label, this.fileChoice.getText());
    }

    public ResultPair getStorableFilledOutData() {
        return new ResultPair(this.label, this.fileChoice.getText());
    }

    public String getFileChoice() {
        return this.fileChoice.getText();
    }

    public void setStorableFilledOutData(ResultPair data) {
        this.fileChoice.setText(data.getValue());
    }

    public static FileChooserField fromXML(Element element, AbstractField.ChangeListener cl) {
        String label = element.getAttribute("label");
        String defaultValue = XML14Util.getChildText((Element)element, (String)"Default", null);
        String buttonLabel = XML14Util.getChildText((Element)element, (String)"ButtonLabel", null);
        String directoryOnlyString = XML14Util.getChildText((Element)element, (String)"DirectoryOnly", null);
        FileChooserField cField = new FileChooserField(label, cl, buttonLabel);
        cField.setDefaultFile(defaultValue);
        if (directoryOnlyString != null) {
            cField.setDirectoryOnly(Boolean.parseBoolean(directoryOnlyString));
        }
        return cField;
    }

    private void initUI(String buttonLabel) {
        this.buttonLabel = buttonLabel;
        this.chooseButton = new JButton();
        if (buttonLabel != null) {
            this.chooseButton.setText(buttonLabel);
        }
        this.fileChoice = new JLabel();
        this.fileChoice.setForeground(Color.DARK_GRAY);
        this.chooseButton.addActionListener(new FileChooserListener());
        this.chooserUI = new GbPanel();
        this.chooserUI.add((Component)this.fileChoice, 0, 0, 1, 1, 1, 1, 10, 1);
        this.chooserUI.add((Component)this.chooseButton, 1, 0, 1, 1, 0, 1, 10, 1);
    }

    public JComponent getComponent() {
        return this.chooserUI;
    }

    public void clearContents() {
        if (this.defaultValue != null) {
            this.fileChoice.setText(this.defaultValue);
        } else {
            this.fileChoice.setText("");
        }
    }

    class FileChooserListener
    implements ActionListener {
        FileChooserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FileChooserField.this.directoryOnly) {
                File file = SafeJFileChooser.pickFile((Component)FileChooserField.this.chooserUI);
                if (file != null) {
                    FileChooserField.this.fileChoice.setText(file.getAbsolutePath());
                    FileChooserField.this.proxyChangeListener.actionPerformed(null);
                }
            } else {
                SafeJFileChooser fc = SafeJFileChooser.getSafeJFileChooser();
                if (FileChooserField.this.directoryOnly) {
                    fc.setFileSelectionMode(1);
                } else {
                    fc.setFileSelectionMode(2);
                }
                fc.setCurrentDirectory(OSDirs.getDesktopDir());
                fc.setMultiSelectionEnabled(false);
                int returnVal = fc.showOpenDialog(null);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    FileChooserField.this.fileChoice.setText(file.getAbsolutePath());
                    FileChooserField.this.proxyChangeListener.actionPerformed(null);
                }
            }
        }
    }
}

