/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.virtualtree;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import utils.swing.components.virtualtree.VirtualTreeInterface;
import utils.swing.components.virtualtree.VirtualTreeNode;

public class VirtualTreeModel
extends DefaultTreeModel {
    private VirtualTreeInterface treeInterface;
    private static final Comparator caseInsensitiveComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    };

    public void addChildNodeInOrder(VirtualTreeNode parent, VirtualTreeNode child) {
        int count;
        int insertIndex = count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeNode childNode = parent.getChildAt(i);
            if (caseInsensitiveComparator.compare(child, childNode) >= 0) continue;
            insertIndex = i;
            break;
        }
        if (count == 0 || insertIndex == count) {
            parent.add(child);
        } else {
            parent.insert(child, insertIndex);
        }
        this.fireTreeNodesInserted(parent, parent.getPath(), new int[]{insertIndex}, new Object[]{child});
    }

    public VirtualTreeModel(VirtualTreeInterface treeInterface) {
        super(new VirtualTreeNode("ROOT"), true);
        this.treeInterface = treeInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChildrenOf(TreePath path) {
        VirtualTreeNode expandedNode;
        VirtualTreeNode virtualTreeNode = expandedNode = (VirtualTreeNode)path.getLastPathComponent();
        synchronized (virtualTreeNode) {
            if (!expandedNode.hasBeenQueried()) {
                expandedNode.setQueried(true);
                new CheckForChildrenThread(expandedNode, path, false).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGrandChildrenOf(TreePath path) {
        VirtualTreeNode expandedNode;
        VirtualTreeNode virtualTreeNode = expandedNode = (VirtualTreeNode)path.getLastPathComponent();
        synchronized (virtualTreeNode) {
            if (!expandedNode.hasBeenQueried()) {
                expandedNode.setQueried(true);
                new CheckForChildrenThread(expandedNode, path, true).start();
            }
        }
    }

    class CheckForChildrenThread
    extends Thread {
        private VirtualTreeNode node;
        private TreePath path;
        private boolean grandChildren;

        public CheckForChildrenThread(VirtualTreeNode node, TreePath path, boolean grandChildren) {
            this.node = node;
            this.grandChildren = grandChildren;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                if (!this.grandChildren) {
                    Object[] children = VirtualTreeModel.this.treeInterface.getChildrenOf(this.node.getUserObject());
                    final TreeNode oldChildNode = this.node.getChildAt(0);
                    this.node.removeAllChildren();
                    Arrays.sort(children, caseInsensitiveComparator);
                    final VirtualTreeNode[] childNodes = new VirtualTreeNode[children.length];
                    final int[] indices = new int[children.length];
                    for (int i = 0; i < children.length; ++i) {
                        childNodes[i] = new VirtualTreeNode(children[i]);
                        indices[i] = i;
                        this.node.insert(childNodes[i], i);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VirtualTreeModel.this.fireTreeNodesRemoved(CheckForChildrenThread.this.node, CheckForChildrenThread.this.path.getPath(), new int[]{0}, new Object[]{oldChildNode});
                            if (childNodes.length > 0) {
                                VirtualTreeModel.this.fireTreeNodesInserted(CheckForChildrenThread.this.node, CheckForChildrenThread.this.path.getPath(), indices, childNodes);
                            }
                        }
                    });
                } else {
                    while (this.node.isUpdating()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException children) {}
                    }
                    for (int i = 0; i < this.node.getChildCount(); ++i) {
                        final VirtualTreeNode childNode = (VirtualTreeNode)this.node.getChildAt(i);
                        final TreePath childPath = this.path.pathByAddingChild(childNode);
                        Object[] children = VirtualTreeModel.this.treeInterface.getChildrenOf(childNode.getUserObject());
                        Arrays.sort(children, caseInsensitiveComparator);
                        final TreeNode oldChildNode = childNode.getChildAt(0);
                        childNode.removeAllChildren();
                        final VirtualTreeNode[] childNodes = new VirtualTreeNode[children.length];
                        final int[] indices = new int[children.length];
                        for (int ii = 0; ii < children.length; ++ii) {
                            childNodes[ii] = new VirtualTreeNode(children[ii]);
                            indices[ii] = ii;
                            childNode.insert(childNodes[ii], ii);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VirtualTreeModel.this.fireTreeNodesRemoved(childNode, childPath.getPath(), new int[]{0}, new Object[]{oldChildNode});
                                if (childNodes.length > 0) {
                                    VirtualTreeModel.this.fireTreeNodesInserted(childNode, childPath.getPath(), indices, childNodes);
                                } else {
                                    VirtualTreeModel.this.reload(childNode);
                                }
                            }
                        });
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

