/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.truncatedarea;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.WrappedPlainView;

public class TruncatedPlainView
extends WrappedPlainView {
    private int lineLimit;
    private Graphics previousG = null;
    private int startY;

    public TruncatedPlainView(Element elem, int lineLimit) {
        super(elem);
        this.lineLimit = lineLimit;
    }

    public TruncatedPlainView(Element elem, boolean wordWrap, int lineLimit) {
        super(elem, wordWrap);
        this.lineLimit = lineLimit;
    }

    @Override
    protected void drawLine(int p0, int p1, Graphics g, int x, int y) {
        Container host = this.getContainer();
        Font f = host.getFont();
        FontMetrics metrics = host.getFontMetrics(f);
        int end = this.getEndOffset();
        if (this.previousG == null || this.previousG != g) {
            this.previousG = g;
            this.startY = y;
            super.drawLine(p0, p1, g, x, y);
        } else {
            int lineCount = (y - this.startY) / metrics.getHeight();
            if (lineCount < this.lineLimit) {
                boolean isEnd;
                boolean bl = isEnd = p1 == end;
                if (lineCount == this.lineLimit - 1 && !isEnd) {
                    super.drawLine(p0, p1 - 3, g, x, y);
                    this.drawEllipsis(g, y);
                } else {
                    super.drawLine(p0, p1, g, x, y);
                }
            }
        }
    }

    private void drawEllipsis(Graphics g, int y) {
        int width = SwingUtilities.computeStringWidth(g.getFontMetrics(), "...");
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawString("...", this.getContainer().getWidth() - width, y);
    }

    public void setLineLimit(int lineLimit) {
        this.lineLimit = lineLimit;
    }
}

