/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.tabs;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollBarUI;
import utils.ostools.OS;
import utils.progtools.OnDemandThreadPool;
import utils.swing.ExponentialSlider;
import utils.swing.SwingUtil;
import utils.swing.borders.RoundRectBorder;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHMiniScrollBarUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ColorFader;
import utils.swing.images.ImageHelper;

public class ScreenShotView
implements AWTEventListener {
    private ColorPropagatingGBPanel rootComponent = new ColorPropagatingGBPanel();
    private JScrollPane pane;
    private ColorPropagatingPanel innerContainer = new ColorPropagatingPanel((LayoutManager)new ScaledFlowLayout());
    private static final int MAX_HEIGHT_SCREEN = 150;
    private static final int TAB_WIDTH = 200;
    private ArrayList<ScreenShotWrapper> screens = new ArrayList();
    private OnDemandThreadPool odtp = new OnDemandThreadPool("ScreenShotView", 1, 10, 5);
    private static int maximumCurrentScreenHeight = 0;
    private static final Color innerContainerBackgroundColor = SHStyle.PANEL_BACKGROUND_WHITE;
    private static final Color tabBackground = SHStyle.PANEL_BACKGROUND_DARKER;
    private static final Color selectedTabBackground = SHStyle.PANEL_BACKGROUND_BLUE;
    private static final RoundRectBorder unselectedBorder = new RoundRectBorder(tabBackground, SimpleHelpLookAndFeel.scale((int)4), SimpleHelpLookAndFeel.scale((int)3), tabBackground);
    private static final RoundRectBorder selectedBorder = new RoundRectBorder(selectedTabBackground, SimpleHelpLookAndFeel.scale((int)4), SimpleHelpLookAndFeel.scale((int)3), selectedTabBackground);
    private int screenShotHeight = 0;
    private ScreenShotWrapper selectedScreen = null;
    private boolean showScreenshots = false;
    private ArrayList<WeakReference<ScreenshotSelectionListener>> listeners = new ArrayList();

    public ScreenShotView() {
        this.initUI();
    }

    public int getIndexFor(Object metadata) {
        for (int i = 0; i < this.screens.size(); ++i) {
            ScreenShotWrapper wrapper = this.screens.get(i);
            if (wrapper.metadata != metadata) continue;
            return i;
        }
        return -1;
    }

    public void updateScreenTitle(Object metadata, String title) {
        for (ScreenShotWrapper wrapper : this.screens) {
            if (wrapper.metadata != metadata) continue;
            wrapper.title = title;
            wrapper.screenPanel.titleUpdated();
        }
    }

    public void updateScreenshot(Object metadata, BufferedImage img) {
        for (ScreenShotWrapper wrapper : this.screens) {
            if (wrapper.metadata != metadata) continue;
            wrapper.screen = img;
            wrapper.screenPanel.screenUpdated();
        }
    }

    public void selectScreen(Object metadata) {
        for (ScreenShotWrapper wrapper : this.screens) {
            if (wrapper.metadata != metadata) continue;
            this.setSelected(wrapper);
        }
    }

    public void addScreenshotSelectionListener(ScreenshotSelectionListener listener) {
        this.listeners.add(new WeakReference<ScreenshotSelectionListener>(listener));
    }

    private void initUI() {
        this.pane = new JScrollPane((Component)this.innerContainer){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = ((ScreenShotView)ScreenShotView.this).innerContainer.getPreferredSize().height;
                if (ScreenShotView.this.pane.getHorizontalScrollBar().isVisible()) {
                    d.height += ScreenShotView.this.pane.getHorizontalScrollBar().getHeight();
                }
                return d;
            }
        };
        this.innerContainer.setLayout((LayoutManager)new BoxLayout((Container)this.innerContainer, 1));
        this.pane.getHorizontalScrollBar().setUI((ScrollBarUI)SHMiniScrollBarUI.createUI(this.pane.getHorizontalScrollBar()));
        this.pane.setBorder(BorderFactory.createEmptyBorder());
        this.pane.setHorizontalScrollBarPolicy(31);
        this.rootComponent.add(this.pane, 0, 0, 1, 1, 1, 1, 10, 1);
        this.rootComponent.setBackground(innerContainerBackgroundColor);
        this.innerContainer.setBackground(innerContainerBackgroundColor);
        this.pane.getHorizontalScrollBar().setBackground(innerContainerBackgroundColor);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
        this.setShowScreenshots(false);
    }

    public void setNotificationCount(String title, int count) {
        for (ScreenShotWrapper wrapper : this.screens) {
            if (!wrapper.title.equals(title)) continue;
            wrapper.setCount(count);
        }
    }

    public void setSelected(ScreenShotWrapper wrapper) {
        if (this.selectedScreen != null) {
            this.selectedScreen.setSelected(false);
        }
        this.selectedScreen = wrapper;
        if (wrapper != null) {
            wrapper.setSelected(true);
            wrapper.selected = true;
            wrapper.screenPanel.selectionUpdated();
        }
        ArrayList<WeakReference<ScreenshotSelectionListener>> remove = new ArrayList<WeakReference<ScreenshotSelectionListener>>();
        for (WeakReference<ScreenshotSelectionListener> ref : this.listeners) {
            ScreenshotSelectionListener listener = (ScreenshotSelectionListener)ref.get();
            if (listener == null) {
                remove.add(ref);
                continue;
            }
            if (wrapper != null) {
                listener.screenshotSelected(wrapper.title, wrapper.metadata);
                continue;
            }
            listener.screenshotSelected(null, null);
        }
        for (WeakReference<ScreenshotSelectionListener> ref : remove) {
            this.listeners.remove(ref);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (this.showScreenshots) {
            MouseEvent e = (MouseEvent)event;
            Point pt = e.getPoint();
            if (!this.rootComponent.getBounds().contains(pt)) {
                this.setShowScreenshots(false);
            }
        }
    }

    public void setShowScreenshots(final boolean showScreenshots) {
        this.showScreenshots = showScreenshots;
        if (showScreenshots) {
            this.pane.setHorizontalScrollBarPolicy(30);
        } else {
            this.pane.setHorizontalScrollBarPolicy(31);
        }
        new Thread(){

            @Override
            public void run() {
                if (showScreenshots) {
                    ScreenShotView.this.odtp.runAsync((Runnable)new GrowJob());
                } else {
                    ScreenShotView.this.odtp.runAsync((Runnable)new ShrinkJob());
                }
            }
        }.start();
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void removeScreen(Object metadata) {
        for (int i = 0; i < this.screens.size(); ++i) {
            ScreenShotWrapper wrapper = this.screens.get(i);
            if (wrapper.metadata != metadata) continue;
            this.screens.remove(i--);
            this.innerContainer.remove((Component)((Object)wrapper.screenPanel));
            break;
        }
        if (this.screens.size() > 0) {
            this.setSelected(this.screens.get(0));
        } else {
            this.setSelected(null);
        }
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    public void addScreen(BufferedImage screenCapture, String title, Object metadata) {
        ScreenShotWrapper wrapper = new ScreenShotWrapper();
        wrapper.screen = screenCapture;
        wrapper.title = title;
        wrapper.metadata = metadata;
        this.screens.add(wrapper);
        ScreenTabPanel screenPanel = new ScreenTabPanel(wrapper);
        this.innerContainer.add((Component)((Object)screenPanel));
        screenPanel.setBackground(this.innerContainer.getBackground());
        if (this.screens.size() == 1) {
            this.setSelected(wrapper);
        }
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    public static void main(String[] args) throws AWTException, InterruptedException {
        GraphicsDevice[] devices;
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setSize(900, 500);
        frame.setLocationRelativeTo(null);
        ScreenShotView view = new ScreenShotView();
        SwingUtil.setWidth((JComponent)view.getRootComponent(), (int)250);
        view.addScreenshotSelectionListener(new ScreenshotSelectionListener(){

            @Override
            public void screenshotSelected(String title, Object metadata) {
                System.out.println("Selected: " + title + " " + metadata);
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)view.getRootComponent(), "West");
        JPanel bottom = new JPanel();
        bottom.setBackground(Color.GRAY);
        panel.add((Component)bottom, "Center");
        frame.getContentPane().add(panel);
        frame.setVisible(true);
        for (GraphicsDevice device : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Robot r = new Robot();
            BufferedImage screenCapture = r.createScreenCapture(device.getDefaultConfiguration().getBounds());
            for (int i = 0; i < 3; ++i) {
                String title = "unstable.simplehelp.io.long.test";
                if (i == 1) {
                    title = "test.simplehelp.io";
                }
                if (i == 2) {
                    title = "192.168.1.72";
                }
                view.addScreen(screenCapture, title, null);
            }
        }
        Thread.sleep(1000L);
        view.setNotificationCount(view.screens.get((int)0).title, 3);
    }

    private class GrowJob
    implements Runnable {
        private GrowJob() {
        }

        @Override
        public void run() {
            if (ScreenShotView.this.showScreenshots && ScreenShotView.this.screenShotHeight < maximumCurrentScreenHeight) {
                try {
                    Thread.sleep(600L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!ScreenShotView.this.showScreenshots) {
                    return;
                }
                ExponentialSlider slider = new ExponentialSlider((double)maximumCurrentScreenHeight, 400L, 10.0, true);
                ColorFader colorFader = new ColorFader(tabBackground, innerContainerBackgroundColor, 10, false);
                ColorFader selectedColorFader = new ColorFader(selectedTabBackground, innerContainerBackgroundColor, 10, false);
                selectedBorder.setCornersToRound(true, true, false, false);
                int step = 0;
                while (!slider.isDone(step)) {
                    ScreenShotView.this.screenShotHeight = slider.getPositionForStepRounded(++step);
                    Color textBackgroundColor = colorFader.nextColor();
                    Color selectedBackgroundColor = selectedColorFader.nextColor();
                    for (ScreenShotWrapper wrapper : ScreenShotView.this.screens) {
                        wrapper.screenPanel.revalidate();
                    }
                    ScreenShotView.this.rootComponent.revalidate();
                    ScreenShotView.this.rootComponent.repaint();
                    try {
                        Thread.sleep(slider.get25fpsSleep());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    class HiDPIImagePanel
    extends JPanel {
        private BufferedImage image;

        public HiDPIImagePanel(BufferedImage image) {
            this.setImage(image);
        }

        public void setImage(BufferedImage image) {
            this.image = image;
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (ScreenShotView.this.screenShotHeight >= 0) {
                d.height = ScreenShotView.this.screenShotHeight;
            }
            return d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            if (this.image == null) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform affineTransform = SwingUtil.prepareForRetina((Graphics2D)g2d);
            try {
                g2d.drawImage(this.image, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
            }
            finally {
                g2d.setTransform(affineTransform);
            }
        }
    }

    class ScreenShotWrapper {
        int count;
        boolean selected = false;
        BufferedImage screen;
        String title;
        Object metadata;
        ScreenTabPanel screenPanel;

        ScreenShotWrapper() {
        }

        public void setCount(int count) {
            this.count = count;
            this.screenPanel.textPanel.repaint();
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.screenPanel.selectionUpdated();
        }
    }

    class ScreenTabPanel
    extends ColorPropagatingPanel
    implements MouseListener {
        private final ScreenShotWrapper wrapper;
        private final HiDPIImagePanel screen;
        private final JLabel text;
        private final JPanel textPanel;

        public ScreenTabPanel(ScreenShotWrapper wrapper) {
            this.screen = new HiDPIImagePanel(null);
            this.text = new JLabel();
            this.textPanel = new JPanel(new GridLayout(1, 1)){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = Math.min(maximumCurrentScreenHeight, ((ScreenTabPanel)ScreenTabPanel.this).screen.getPreferredSize().width);
                    d.height = SimpleHelpLookAndFeel.scale((int)28);
                    return d;
                }

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    if (((ScreenTabPanel)ScreenTabPanel.this).wrapper.count > 0) {
                        Graphics2D g2d = (Graphics2D)g;
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        int size = SimpleHelpLookAndFeel.scale((int)10);
                        g2d.setColor(SHStyle.NOTIFICATIONS_CIRCLE);
                        g2d.fillArc(this.getWidth() - size - SimpleHelpLookAndFeel.scale((int)2), SimpleHelpLookAndFeel.scale((int)2), size, size, 0, 360);
                    }
                }
            };
            this.wrapper = wrapper;
            this.wrapper.screenPanel = this;
            this.textPanel.add(this.text);
            this.setLayout(new BorderLayout());
            this.add(this.textPanel, "North");
            this.add(this.screen, "Center");
            this.text.setHorizontalAlignment(0);
            this.titleUpdated();
            this.screenUpdated();
            this.selectionUpdated();
            this.setBorder(SHBorderFactory.createEmptyBorder((int)2, (int)5, (int)2, (int)5));
            this.screen.addMouseListener(this);
            this.text.addMouseListener(this);
            this.addMouseListener(this);
        }

        public void titleUpdated() {
            float fontSize = 14.0f;
            this.text.setFont(this.text.getFont().deriveFont(fontSize));
            this.text.setText(" " + this.wrapper.title + " ");
            if (this.text.getPreferredSize().width > maximumCurrentScreenHeight) {
                this.text.setText(this.wrapper.title);
            }
            if (this.text.getPreferredSize().width > maximumCurrentScreenHeight) {
                this.text.setFont(this.text.getFont().deriveFont(12.0f));
            }
            if (this.text.getPreferredSize().width > maximumCurrentScreenHeight) {
                this.text.setFont(this.text.getFont().deriveFont(11.0f));
            }
        }

        public void selectionUpdated() {
            if (this.wrapper.selected) {
                this.textPanel.setBorder((Border)selectedBorder);
            } else {
                this.textPanel.setBorder((Border)unselectedBorder);
            }
        }

        public void screenUpdated() {
            int w = SimpleHelpLookAndFeel.scale((int)200);
            int h = SimpleHelpLookAndFeel.scale((int)200);
            BufferedImage smallerImage = OS.isOSXRetina() ? ImageHelper.scaleDownToFitInside((BufferedImage)this.wrapper.screen, (int)(w * 2), (int)(h * 2), (boolean)true) : ImageHelper.scaleDownToFitInside((BufferedImage)this.wrapper.screen, (int)w, (int)h, (boolean)true);
            if (OS.isOSXRetina()) {
                w = smallerImage.getWidth() / 2;
                h = smallerImage.getHeight() / 2;
            } else {
                w = smallerImage.getWidth();
                h = smallerImage.getHeight();
            }
            this.screen.setPreferredSize(new Dimension(w, h));
            maximumCurrentScreenHeight = Math.max(maximumCurrentScreenHeight, h);
            this.screen.setImage(smallerImage);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ScreenShotView.this.setSelected(this.wrapper);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ScreenShotView.this.setShowScreenshots(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public static interface ScreenshotSelectionListener {
        public void screenshotSelected(String var1, Object var2);
    }

    private class ShrinkJob
    implements Runnable {
        private ShrinkJob() {
        }

        @Override
        public void run() {
            if (!ScreenShotView.this.showScreenshots && ScreenShotView.this.screenShotHeight > 0) {
                ExponentialSlider slider = new ExponentialSlider((double)maximumCurrentScreenHeight, 400L, 10.0, true);
                ColorFader colorFader = new ColorFader(innerContainerBackgroundColor, tabBackground, 10, false);
                ColorFader selectedColorFader = new ColorFader(innerContainerBackgroundColor, selectedTabBackground, 10, false);
                selectedBorder.setCornersToRound(true, true, true, true);
                int step = 0;
                while (!slider.isDone(step)) {
                    ScreenShotView.this.screenShotHeight = maximumCurrentScreenHeight - slider.getPositionForStepRounded(++step);
                    Color textBackgroundColor = colorFader.nextColor();
                    Color selectedBackgroundColor = selectedColorFader.nextColor();
                    for (ScreenShotWrapper wrapper : ScreenShotView.this.screens) {
                        wrapper.screenPanel.revalidate();
                    }
                    ScreenShotView.this.rootComponent.revalidate();
                    ScreenShotView.this.rootComponent.repaint();
                    try {
                        Thread.sleep(slider.get25fpsSleep());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

