/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.switches.image;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JPanel;

public class Switch
extends JPanel
implements MouseListener {
    private Icon on;
    private Icon off;
    private Icon undefined;
    private boolean isSelected;
    private boolean isUndefined;
    private ActionListener listener;

    public Switch(Icon on, Icon off, Icon undefined) {
        this.on = on;
        this.off = off;
        this.undefined = undefined;
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isUndefined) {
            this.undefined.paintIcon(this, g, 0, 0);
        } else if (this.isSelected) {
            this.on.paintIcon(this, g, 0, 0);
        } else {
            this.off.paintIcon(this, g, 0, 0);
        }
    }

    @Override
    public String toString() {
        return "ImageSwitch";
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
        this.isUndefined = false;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isUndefined() {
        return this.isUndefined;
    }

    public void setUndefined() {
        this.isSelected = true;
        this.isUndefined = true;
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isUndefined) {
            this.isUndefined = false;
            this.isSelected = true;
        } else {
            boolean bl = this.isSelected = !this.isSelected;
        }
        if (this.listener != null) {
            ActionEvent event = new ActionEvent(this, 0, "");
            this.listener.actionPerformed(event);
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

