/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.reorderablepanel;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class DraggableMouseListener
implements MouseMotionListener,
MouseListener {
    private boolean drag = false;
    private boolean exportedAsDrag = false;
    private JComponent sourceComponent;

    DraggableMouseListener() {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.drag && !this.exportedAsDrag) {
            this.exportedAsDrag = true;
            TransferHandler handler = this.sourceComponent.getTransferHandler();
            handler.exportAsDrag(this.sourceComponent, e, 1);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.drag = true;
        this.sourceComponent = (JComponent)e.getSource();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.drag = false;
        this.exportedAsDrag = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

