/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.messagefields;

import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import utils.swing.components.messagefields.MessageComponent;
import utils.swing.components.messagefields.MessageFieldHandler;

public class MessageTextArea
extends JTextArea
implements MessageComponent {
    private final MessageFieldHandler handler;

    public MessageTextArea(String message, MessageFieldHandler.FilterListener filterListener) {
        this.handler = new MessageFieldHandler((JTextComponent)this, message, filterListener);
        this.handler.init();
    }

    @Override
    public String getText() {
        if (this.handler.hasEnteredText()) {
            return super.getText();
        }
        return "";
    }

    @Override
    public void setText(String text) {
        if (text == null || text.length() == 0) {
            if (!this.hasFocus()) {
                this.handler.clear();
            } else {
                super.setText("");
            }
        } else {
            super.setText(text);
            this.handler.setDefaultColor();
        }
        this.repaint();
    }

    public void clear() {
        this.handler.clear();
        if (!this.hasFocus()) {
            super.setText(this.handler.getSearchText());
            this.handler.setGrayColor();
        } else {
            super.setText("");
        }
    }

    public void setMessageText(String message) {
        this.handler.setMessageText(message);
    }

    public boolean hasEnteredText() {
        return this.handler.hasEnteredText();
    }
}

