/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.avatar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import utils.stream.StreamUtils;
import utils.swing.SafeJFileChooser;
import utils.swing.components.FitImagePanel;
import utils.swing.customlaf.SHStyle;

public class AvatarPanel
extends FitImagePanel
implements MouseListener,
MouseMotionListener {
    private AvatarChangeListener changeListener;
    private boolean loading;
    private boolean drawClose = false;
    private Icon closeImage;
    private Image defaultImage;
    private Dimension dim;

    public AvatarPanel(int width, int height, Image image, Image defaultImage, Icon closeImage) {
        this(width, height, image, defaultImage, null, closeImage);
    }

    public AvatarPanel(int width, int height, Image image, Image defaultImage, AvatarChangeListener changeListener, Icon closeImage) {
        this.setAvatarImage(image);
        this.changeListener = changeListener;
        this.dim = new Dimension(width, height);
        this.setPreferredSize(this.dim);
        this.setMinimumSize(this.dim);
        this.setMaximumSize(this.dim);
        this.setSize(this.dim);
        this.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        this.closeImage = closeImage;
        this.defaultImage = defaultImage;
        if (changeListener != null) {
            this.addMouseListener(this);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    public void setAvatarLoading() {
        this.loading = true;
    }

    public void setAvatarImage(byte[] avatarImageBytes) {
        if (avatarImageBytes == null || avatarImageBytes.length == 0) {
            this.setImage(null);
            this.setAvatarImage((Image)null);
            return;
        }
        try {
            BufferedImage read = ImageIO.read(new ByteArrayInputStream(avatarImageBytes));
            this.setAvatarImage(read);
        }
        catch (IOException e) {
            System.out.println("[AvatarPanel] Unable to load image.");
            e.printStackTrace();
            this.setAvatarImage((Image)null);
        }
    }

    public void setAvatarImage(Image image) {
        if (image != null) {
            this.setImage(image);
        } else {
            this.setImage(this.defaultImage);
        }
        this.loading = false;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        super.paintComponent(g);
        if (!this.isEnabled()) {
            g.setColor(new Color(246, 245, 244, 150));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        if (!this.loading && this.closeImage != null && this.drawClose && this.image != null) {
            int destinationWidth = this.getWidth() - insets.right;
            this.closeImage.paintIcon((Component)((Object)this), g, destinationWidth - this.closeImage.getIconWidth(), insets.top);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.closeImage != null && this.drawClose) {
            Insets insets = this.getInsets();
            int destinationWidth = this.getWidth() - insets.right;
            if (y < insets.top + this.closeImage.getIconHeight() && x > destinationWidth - this.closeImage.getIconWidth()) {
                this.setAvatarImage((Image)null);
                this.changeListener.avatarChanged(null);
                return;
            }
        }
        this.openLoadDialog();
    }

    private void openLoadDialog() {
        File pickedFile = SafeJFileChooser.pickFile((Component)((Object)this));
        if (pickedFile != null) {
            BufferedImage image = null;
            try {
                byte[] readAll = StreamUtils.readAll((InputStream)new FileInputStream(pickedFile));
                image = ImageIO.read(new ByteArrayInputStream(readAll));
                this.setAvatarImage(image);
                this.changeListener.avatarChanged(readAll);
            }
            catch (IOException e) {
                return;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.drawClose = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.drawClose = false;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static interface AvatarChangeListener {
        public void avatarChanged(byte[] var1);
    }
}

