/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.animated.arrow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import utils.swing.components.animated.AbstractAnimatedIcon;
import utils.swing.components.animated.arrow.ArrowDrawer;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class ArrowOverlayIcon
extends AbstractAnimatedIcon {
    private Icon icon;
    private ArrowDrawer drawer = new ArrowDrawer(false);
    private int offsetY = 0;
    private int offsetX = 0;

    public ArrowOverlayIcon(Icon icon) {
        this.icon = icon;
    }

    public void setArrowOffsets(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    public void setDrawerColor(Color foreground) {
        this.drawer.setForeground(foreground);
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    protected void paintFrame(Component c, Graphics g, int x, int y) {
        this.icon.paintIcon(c, g, x, y);
        int xx = x + this.getIconWidth() / 2 - SimpleHelpLookAndFeel.scale((int)16) / 2 + this.offsetX;
        int yy = y + this.getIconHeight() / 2 - SimpleHelpLookAndFeel.scale((int)16) / 2 + this.offsetY;
        this.drawer.paintForeground((Graphics2D)g, xx, yy, SimpleHelpLookAndFeel.scale((int)16), SimpleHelpLookAndFeel.scale((int)16));
    }
}

