/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.switches.oem.OEMSwitches;

public class SimpleTabbedPanel {
    private Color borderColor = SHButtonUI.getBorderColor((SHUI.ButtonColor)SHUI.BUTTON_NORMAL, (boolean)false);
    public static final int TAB_HEIGHT = SimpleHelpLookAndFeel.scale((int)40);
    public static final int TAB_PADDING = SimpleHelpLookAndFeel.scale((int)5);
    private Font titleFont = SHStyle.mediumFont;
    public static final boolean FADE_TAB_BOTTOMS = false;
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private JPanel buttonsPanel = new JPanel(new BorderLayout());
    private JPanel leftButtonGrid = new JPanel((LayoutManager)new ScaledFlowLayout(0, 0, 0));
    private JPanel middleEmptyGrid = new JPanel(new GridLayout(1, 1));
    private JPanel rightButtonGrid = new JPanel((LayoutManager)new ScaledFlowLayout(2, 0, 0));
    private CardLayout contentPanelLayout = new CardLayout();
    private JPanel contentPanel = new JPanel(this.contentPanelLayout);
    private ArrayList<TabButton> leftTabButtons = new ArrayList();
    private ArrayList<TabButton> rightTabButtons = new ArrayList();
    private TabActionListener actionListener = new TabActionListener();
    protected boolean globallyShowLabels = true;
    private JComponent showingPanel;
    private Icon showingIcon;
    private ArrayList<ChangeListener> changeListeners = new ArrayList();

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public SimpleTabbedPanel() {
        this.initUI();
    }

    public void useSmallFonts() {
        this.setTitleFont(SHStyle.normalFont);
    }

    private void initUI() {
        this.rootComponent.add((Component)this.buttonsPanel, "North");
        this.rootComponent.add((Component)this.contentPanel, "Center");
        this.buttonsPanel.add((Component)this.leftButtonGrid, "West");
        this.buttonsPanel.add((Component)this.middleEmptyGrid, "Center");
        this.buttonsPanel.add((Component)this.rightButtonGrid, "East");
        this.middleEmptyGrid.add(new EmptySpace());
        this.middleEmptyGrid.addComponentListener(new ComponentListener(){
            int midWidth = Integer.MAX_VALUE;

            @Override
            public void componentResized(ComponentEvent e) {
                if (SimpleTabbedPanel.this.globallyShowLabels) {
                    if (((SimpleTabbedPanel)SimpleTabbedPanel.this).middleEmptyGrid.getSize().width < 10) {
                        SimpleTabbedPanel.this.globallyShowLabels = false;
                        SimpleTabbedPanel.this.leftButtonGrid.revalidate();
                        SimpleTabbedPanel.this.buttonsPanel.repaint();
                    } else {
                        this.midWidth = Math.min(SimpleTabbedPanel.this.buttonsPanel.getWidth(), this.midWidth);
                    }
                } else if (SimpleTabbedPanel.this.buttonsPanel.getWidth() > this.midWidth) {
                    SimpleTabbedPanel.this.globallyShowLabels = true;
                    SimpleTabbedPanel.this.leftButtonGrid.revalidate();
                    SimpleTabbedPanel.this.buttonsPanel.repaint();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void addButton(String title, Icon icon, ActionListener listener, boolean left, boolean showText) {
        this.addTab(title, icon, null, left, showText, listener);
    }

    public void addTab(String title, Icon icon, JComponent contentPanel, boolean left, boolean showText) {
        this.addTab(title, icon, contentPanel, left, showText, null);
    }

    public void addTab(String title, Icon icon, JComponent contentPanel, boolean left, boolean showText, ActionListener listener) {
        TabOption option = new TabOption(title, icon, contentPanel, showText, listener);
        if (left && this.leftTabButtons.size() == 0) {
            option.isForeground = true;
        }
        TabButton buttonUI = new TabButton(option);
        if (left) {
            this.leftTabButtons.add(buttonUI);
            this.leftButtonGrid.add(buttonUI);
        } else {
            this.rightTabButtons.add(buttonUI);
            this.rightButtonGrid.add(buttonUI);
        }
        if (contentPanel != null) {
            this.contentPanel.add((Component)contentPanel, title);
        }
        this.setBorders();
    }

    public void addTab(String title, Icon icon, JComponent contentPanel) {
        this.addTab(title, icon, contentPanel, true, true);
    }

    public void addRightTab(String title, Icon icon, JPanel contentPanel) {
        this.addTab(title, icon, contentPanel, false, true);
    }

    public void addRightButton(String title, Icon icon, ActionListener listener) {
        this.addButton(title, icon, listener, false, false);
    }

    private void setBorders() {
        boolean drawRight;
        boolean drawLeft;
        TabButton button;
        int i;
        TabButton previous = null;
        for (i = 0; i < this.leftTabButtons.size(); ++i) {
            button = this.leftTabButtons.get(i);
            drawLeft = false;
            drawRight = true;
            if ((((TabButton)button).option.isForeground || ((TabButton)button).option.isSelected) && previous != null) {
                previous.drawRightBorder = false;
                drawLeft = true;
            }
            button.setDrawBorders(drawLeft, drawRight);
            previous = button;
        }
        for (i = 0; i < this.rightTabButtons.size(); ++i) {
            button = this.rightTabButtons.get(i);
            drawLeft = true;
            drawRight = false;
            button.setDrawBorders(drawLeft, drawRight);
        }
        this.buttonsPanel.repaint();
    }

    private boolean match(Icon icon1, Icon icon2) {
        if (icon1 == icon2) {
            return true;
        }
        if (icon1 instanceof ImageIcon && icon2 instanceof ImageIcon) {
            return ((ImageIcon)icon1).getImage() == ((ImageIcon)icon2).getImage();
        }
        return false;
    }

    public void selectTab(Icon icon) {
        for (TabButton tab : this.leftTabButtons) {
            if (!this.match(((TabButton)tab).option.icon, icon)) continue;
            this.selectTab(tab);
            return;
        }
        for (TabButton tab : this.rightTabButtons) {
            if (!this.match(((TabButton)tab).option.icon, icon)) continue;
            this.selectTab(tab);
            return;
        }
    }

    public void selectTab(TabButton button) {
        if (((TabButton)button).option.contentPanel != null) {
            for (TabButton tab : this.leftTabButtons) {
                ((TabButton)tab).option.isForeground = false;
            }
            for (TabButton tab : this.rightTabButtons) {
                ((TabButton)tab).option.isForeground = false;
            }
            ((TabButton)button).option.isForeground = true;
            this.contentPanelLayout.show(this.contentPanel, ((TabButton)button).option.title);
            this.showingPanel = ((TabButton)button).option.contentPanel;
            this.showingIcon = ((TabButton)button).option.icon;
            this.setBorders();
            this.buttonsPanel.repaint();
        } else if (button.option.listener != null) {
            ((TabButton)button).option.isSelected = !((TabButton)button).option.isSelected;
            this.buttonsPanel.repaint();
            ActionEvent e = new ActionEvent(button, 1001, null);
            button.option.listener.actionPerformed(e);
        }
        for (ChangeListener listener : this.changeListeners) {
            ChangeEvent e = new ChangeEvent(this.rootComponent);
            listener.stateChanged(e);
        }
    }

    public void setSelectedComponent(JComponent componentToShow) {
        TabButton button = this.getTabButtonFor(componentToShow);
        if (button != null) {
            this.selectTab(button);
        }
    }

    private TabButton getTabButtonFor(JComponent componentToShow) {
        for (TabButton button : this.leftTabButtons) {
            if (((TabButton)button).option.contentPanel != componentToShow) continue;
            return button;
        }
        for (TabButton button : this.rightTabButtons) {
            if (((TabButton)button).option.contentPanel != componentToShow) continue;
            return button;
        }
        return null;
    }

    private TabButton getTabButtonByName(String title) {
        for (TabButton button : this.leftTabButtons) {
            if (!((TabButton)button).option.title.equals(title)) continue;
            return button;
        }
        for (TabButton button : this.rightTabButtons) {
            if (!((TabButton)button).option.title.equals(title)) continue;
            return button;
        }
        return null;
    }

    public int getTabCount() {
        return this.leftTabButtons.size() + this.rightTabButtons.size();
    }

    public void setSelectedIndex(int i) {
        TabButton button = i < this.leftTabButtons.size() ? this.leftTabButtons.get(i) : this.rightTabButtons.get(i - this.leftTabButtons.size());
        this.selectTab(button);
    }

    public int getSelectedIndex() {
        int i;
        for (i = 0; i < this.leftTabButtons.size(); ++i) {
            if (!this.leftTabButtons.get(i).isForeground()) continue;
            return i;
        }
        for (i = 0; i < this.rightTabButtons.size(); ++i) {
            if (!this.rightTabButtons.get(i).isForeground()) continue;
            return this.leftTabButtons.size() + i;
        }
        return 0;
    }

    public Icon getSelectedIcon() {
        return this.showingIcon;
    }

    public JComponent getSelectedComponent() {
        return this.showingPanel;
    }

    public void removeAll() {
        this.leftButtonGrid.removeAll();
        this.rightButtonGrid.removeAll();
        this.contentPanel.removeAll();
        this.leftTabButtons.clear();
        this.rightTabButtons.clear();
    }

    public void setBorder(Border createEmptyBorder) {
        this.rootComponent.setBorder(createEmptyBorder);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public Component getContentPanel() {
        return this.contentPanel;
    }

    public void setTabCounter(JComponent contentPanel, int count) {
        TabButton button = this.getTabButtonFor(contentPanel);
        if (button != null) {
            ((TabButton)button).option.icon = ImageLoader.getIncrementalOverlayedIcon((Icon)((TabButton)button).option.original, (int)count);
            button.repaint();
            if (OS.isMacOS()) {
                OSXAdapter.setDockIconBadge((String)("" + count));
            }
        }
    }

    public void setTabCounter(String name, int unreadCount) {
        TabButton button = this.getTabButtonByName(name);
        if (button != null) {
            ((TabButton)button).option.icon = unreadCount <= 0 ? ((TabButton)button).option.original : ImageLoader.getIncrementalOverlayedIcon((Icon)((TabButton)button).option.original, (int)unreadCount);
            button.repaint();
            if (OS.isMacOS()) {
                if (unreadCount > 0) {
                    OSXAdapter.setDockIconBadge((String)("" + unreadCount));
                } else {
                    OSXAdapter.setDockIconBadge(null);
                }
            }
        }
    }

    class EmptySpace
    extends TabButton {
        public EmptySpace() {
            super(null);
            if (OEMSwitches.DARK_THEME) {
                this.setBackground(SHStyle.SIMPLE_TAB_BACKGROUND_DARK);
            } else {
                this.setBackground(SHStyle.SIMPLE_TAB_BACKGROUND_LIGHT);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setStroke(SHButtonUI.getBorderStroke());
            float width = SHButtonUI.getBorderStrokeWidth();
            g2d.setColor(SimpleTabbedPanel.this.borderColor);
            g2d.draw(new Line2D.Float(0.0f, (float)this.getHeight() - width, (float)this.getWidth() - width, (float)this.getHeight() - width));
        }
    }

    class TabActionListener
    implements MouseListener {
        TabActionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            for (TabButton button : SimpleTabbedPanel.this.leftTabButtons) {
                if (button != e.getSource()) continue;
                SimpleTabbedPanel.this.selectTab(button);
                return;
            }
            for (TabButton button : SimpleTabbedPanel.this.rightTabButtons) {
                if (button != e.getSource()) continue;
                SimpleTabbedPanel.this.selectTab(button);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class TabButton
    extends JPanel {
        private TabOption option;
        private boolean drawRightBorder = true;
        private boolean drawLeftBorder = true;

        public TabButton(TabOption option) {
            this.option = option;
            this.addMouseListener(SimpleTabbedPanel.this.actionListener);
        }

        public boolean isForeground() {
            if (this.option != null) {
                return this.option.isForeground;
            }
            return false;
        }

        public void setDrawBorders(boolean drawLeftBorder, boolean drawRightBorder) {
            this.drawLeftBorder = drawLeftBorder;
            this.drawRightBorder = drawRightBorder;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.height = TAB_HEIGHT;
            if (this.option == null) {
                return dim;
            }
            if (this.option.showText && SimpleTabbedPanel.this.globallyShowLabels) {
                dim.width = this.getFontMetrics(SimpleTabbedPanel.this.titleFont).stringWidth(this.option.title) + TAB_PADDING * 4;
                if (this.option.icon != null) {
                    dim.width += this.option.icon.getIconWidth();
                }
            } else {
                dim.width = this.option.icon != null ? TAB_PADDING * 2 + this.option.icon.getIconWidth() : TAB_PADDING * 2;
            }
            return dim;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.option.isForeground || this.option.isSelected) {
                this.draw(g2d, true);
            } else {
                this.draw(g2d, false);
            }
            int iconWidth = 0;
            if (this.option.icon != null) {
                iconWidth = this.option.icon.getIconWidth();
                int y = (this.getHeight() - this.option.icon.getIconHeight()) / 2;
                this.option.icon.paintIcon(this, g2d, TAB_PADDING, y);
            }
            if (this.option.showText && SimpleTabbedPanel.this.globallyShowLabels) {
                g2d.setFont(SimpleTabbedPanel.this.titleFont);
                if (OEMSwitches.DARK_THEME) {
                    g2d.setColor(Color.white);
                }
                int ascent = g2d.getFontMetrics().getAscent();
                int y = (this.getHeight() + ascent) / 2;
                int stringWidth = SwingUtilities.computeStringWidth(g2d.getFontMetrics(), this.option.title);
                int x = (this.getWidth() - iconWidth - TAB_PADDING * 2) / 2 - stringWidth / 2 + iconWidth + TAB_PADDING;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.drawString(this.option.title, x, y);
                if (OEMSwitches.DARK_THEME) {
                    g2d.drawString(this.option.title, x, y);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void draw(Graphics2D g, boolean selected) {
            Color c = g.getColor();
            try {
                if (!OEMSwitches.DARK_THEME) {
                    if (selected) {
                        g.setPaint(SHButtonUI.getFill((SHUI.ButtonColor)SHUI.BUTTON_NORMAL, (boolean)true, (int)this.getHeight(), (boolean)false));
                    } else {
                        g.setPaint(SHButtonUI.getFill((SHUI.ButtonColor)SHUI.BUTTON_NORMAL, (boolean)false, (int)this.getHeight(), (boolean)false));
                    }
                } else if (selected) {
                    g.setPaint(SHButtonUI.getFill((SHUI.ButtonColor)SHUI.BUTTON_BLUE, (boolean)true, (int)this.getHeight(), (boolean)false));
                } else {
                    g.setPaint(SHButtonUI.getFill((SHUI.ButtonColor)SHUI.BUTTON_NORMAL, (boolean)false, (int)this.getHeight(), (boolean)false));
                }
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(SimpleTabbedPanel.this.borderColor);
                g.setStroke(SHButtonUI.getBorderStroke());
                float width = SHButtonUI.getBorderStrokeWidth();
                if (this.drawRightBorder) {
                    g.draw(new Line2D.Float((float)this.getWidth() - width, 0.0f, (float)this.getWidth() - width, (float)this.getHeight() - width));
                }
                if (this.drawLeftBorder) {
                    g.draw(new Line2D.Float(0.0f, 0.0f, 0.0f, (float)this.getHeight() - width));
                }
                if (!selected) {
                    g.draw(new Line2D.Float(0.0f, (float)this.getHeight() - width, (float)this.getWidth() - width, (float)this.getHeight() - width));
                }
            }
            finally {
                g.setColor(c);
            }
        }
    }

    public class TabOption {
        String title;
        Icon icon;
        Icon original;
        JComponent contentPanel;
        boolean isForeground = false;
        boolean isSelected = false;
        boolean showText;
        private ActionListener listener;

        public TabOption(String title, Icon icon, JComponent contentPanel, boolean showText, ActionListener listener) {
            this.title = title;
            this.listener = listener;
            this.icon = icon;
            this.original = icon;
            this.contentPanel = contentPanel;
            this.showText = showText;
        }
    }
}

