/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;

public class SHProgressBarPanel
extends JPanel {
    private double dPercentage = -1.0;

    public void setPercentage(int percentage) {
        if (percentage == -1) {
            this.dPercentage = -1.0;
            return;
        }
        this.dPercentage = (double)percentage / 100.0;
        if (this.dPercentage > 100.0) {
            this.dPercentage = 100.0;
        }
        if (this.dPercentage < 0.0) {
            this.dPercentage = 0.0;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dPercentage == -1.0) {
            return;
        }
        int leftBuffer = 4;
        int arc = 2;
        int height = 4;
        int y = (this.getHeight() - height) / 2;
        g.setColor(Color.WHITE);
        g.fillRoundRect(leftBuffer, y, this.getWidth() - 2 * leftBuffer - 1, height, arc, arc);
        if (this.isEnabled()) {
            g.setColor(SHStyle.MINI_PROGRESS_FILL);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        int width = (int)(this.dPercentage * (double)(this.getWidth() - 2 * leftBuffer - 1));
        g.fillRoundRect(leftBuffer, y, width, height, arc, arc);
        g.setColor(Color.LIGHT_GRAY);
        g.drawRoundRect(leftBuffer, y, this.getWidth() - 2 * leftBuffer - 1, height, arc, arc);
    }

    public static void main(String[] args) {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        SHProgressBarPanel panel = new SHProgressBarPanel();
        frame.getContentPane().add(panel);
        frame.setVisible(true);
        for (int i = 0; i <= 100; ++i) {
            panel.setPercentage(i);
            panel.repaint();
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

