/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JWrapTextPaneLabel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class NoContentsInfoPanel
extends JPanel {
    private final boolean useForUpsell;
    private Icon noContentsImage;
    private boolean hasContents = false;
    private CardLayout cl;
    private GbPanel noContentsPanel = new ColorPropagatingGBPanel();
    private JPanel topHalf = new ColorPropagatingPanel((LayoutManager)new BorderLayout());
    private final JLabel iconLabel;
    private JLabel label;
    private GbPanel middle = new ColorPropagatingGBPanel();
    private static final String NONE = "0";
    private static final String CONTENTS = "1";
    private ArrayList<JComponent> subTextLabels = new ArrayList();

    public NoContentsInfoPanel(String noContentsText, Icon icon, boolean initiallyHasContents) {
        this(noContentsText, icon, initiallyHasContents, false);
    }

    public NoContentsInfoPanel(String noContentsText, Icon icon, boolean initiallyHasContents, boolean useForUpsell) {
        this.useForUpsell = useForUpsell;
        this.noContentsImage = icon;
        this.hasContents = initiallyHasContents;
        this.label = new JLabel(noContentsText);
        this.label.setForeground(this.getTitleColor());
        this.label.setFont(this.label.getFont().deriveFont(SimpleHelpLookAndFeel.scale((float)16.0f)));
        this.label.setHorizontalAlignment(0);
        this.iconLabel = new JLabel();
        this.iconLabel.setHorizontalAlignment(0);
        this.noContentsPanel.add((Component)this.topHalf, 0, 0, 1, 1, 1, 1, 10, 1);
        this.noContentsPanel.add((Component)this.middle, 0, 1, 1, 1, 1, 1, 10, 1);
        ColorPropagatingPanel iconAndDescription = new ColorPropagatingPanel((LayoutManager)new BorderLayout(SimpleHelpLookAndFeel.scale((int)20), SimpleHelpLookAndFeel.scale((int)20)));
        iconAndDescription.add((Component)this.iconLabel, "Center");
        iconAndDescription.add((Component)this.label, "South");
        this.topHalf.add((Component)iconAndDescription, "South");
        this.noContentsPanel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        this.setIcon(icon);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        d.height = Math.min(SimpleHelpLookAndFeel.scale((int)70), d.height);
        return d;
    }

    private Color getTitleColor() {
        if (this.useForUpsell) {
            return SHStyle.EXAMPLE_TEXT_COLOR;
        }
        return SHStyle.EXAMPLE_TEXT_COLOR_LIGHT;
    }

    private Color getSubTextColor() {
        if (this.useForUpsell) {
            return SHStyle.EXAMPLE_TEXT_COLOR;
        }
        return SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST;
    }

    public void setIcon(Icon icon) {
        this.noContentsImage = icon;
        this.iconLabel.setIcon(this.noContentsImage);
    }

    public void setTitle(String text) {
        this.label.setText(text);
    }

    public void setSubText(String[] text) {
        for (JComponent jComponent : this.subTextLabels) {
            this.middle.remove((Component)jComponent);
        }
        this.subTextLabels.clear();
        int Y = 1;
        for (String s : text) {
            if (s == null) continue;
            JWrapTextPaneLabel subText = new JWrapTextPaneLabel(s);
            subText.setForeground(this.getSubTextColor());
            this.subTextLabels.add(subText);
            this.middle.add((Component)subText, 0, Y++, 1, 1, 1, 0, 11, 1, (Insets)new ScaledInsets(Y == 2 ? 30 : 0, 20, 20, 20));
        }
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.middle.getBackground());
        this.middle.add((Component)jPanel, 0, Y++, 1, 1, 1, 1, 11, 1, (Insets)new ScaledInsets(Y == 2 ? 30 : 0, 20, 20, 20));
        this.subTextLabels.add(jPanel);
        this.middle.revalidate();
        this.middle.repaint();
    }

    public void setSubText(String text) {
        this.setSubText(new String[]{text});
    }

    public void setContentsPanel(JComponent contentsPanel) {
        this.initUI(contentsPanel);
    }

    public void setFont(Font font, Color color) {
        this.label.setFont(font);
        this.label.setForeground(color);
    }

    public void setNoContentsBackground(Color color) {
        this.noContentsPanel.setBackground(color);
    }

    public void setNoContentsBorder(Border border) {
        this.noContentsPanel.setBorder(border);
    }

    private void initUI(JComponent contentsPanel) {
        this.cl = new CardLayout();
        this.setLayout(this.cl);
        this.add((Component)this.noContentsPanel, NONE);
        this.add((Component)contentsPanel, CONTENTS);
        if (this.hasContents) {
            this.cl.show(this, CONTENTS);
        } else {
            this.cl.show(this, NONE);
        }
    }

    public void setHasContents(boolean hasContents) {
        this.hasContents = hasContents;
        if (hasContents) {
            this.cl.show(this, CONTENTS);
        } else {
            this.cl.show(this, NONE);
        }
    }
}

