/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class ColorButton
extends JButton {
    private final ColorIcon icon;

    public ColorButton(Color color, String text) {
        this.setIconTextGap(SimpleHelpLookAndFeel.scale((int)16));
        this.setText(text);
        this.icon = new ColorIcon(color);
        this.setIcon(this.icon);
        this.setMargin((Insets)new ScaledInsets(7, 7, 7, 7));
    }

    public void setColor(Color color) {
        this.icon.color = color;
        this.repaint();
    }

    public Color getColor() {
        return this.icon.color;
    }

    private static class ColorIcon
    implements Icon {
        private Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(this.color.darker());
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return SimpleHelpLookAndFeel.scale((int)24);
        }

        @Override
        public int getIconHeight() {
            return SimpleHelpLookAndFeel.scale((int)14);
        }
    }
}

