/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.color.colorpicker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import utils.swing.color.colorpicker.PlafPaintUtils;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;

public class ColorPickerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SIZE = 325;
    private int mode = 1;
    private Point point = new Point(0, 0);
    private Vector<ChangeListener> changeListeners = new Vector();
    float hue = -1.0f;
    float sat = -1.0f;
    float bri = -1.0f;
    int red = -1;
    int green = -1;
    int blue = -1;
    MouseInputListener mouseListener = new MouseInputAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            ColorPickerPanel.this.requestFocus();
            Point p = e.getPoint();
            if (ColorPickerPanel.this.mode == 1 || ColorPickerPanel.this.mode == 2 || ColorPickerPanel.this.mode == 0) {
                float[] hsb = ColorPickerPanel.this.getHSB(p);
                ColorPickerPanel.this.setHSB(hsb[0], hsb[1], hsb[2]);
            } else {
                int[] rgb = ColorPickerPanel.this.getRGB(p);
                ColorPickerPanel.this.setRGB(rgb[0], rgb[1], rgb[2]);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mousePressed(e);
        }
    };
    KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int dx = 0;
            int dy = 0;
            if (e.getKeyCode() == 37) {
                dx = -1;
            } else if (e.getKeyCode() == 39) {
                dx = 1;
            } else if (e.getKeyCode() == 38) {
                dy = -1;
            } else if (e.getKeyCode() == 40) {
                dy = 1;
            }
            int multiplier = 1;
            if (e.isShiftDown() && e.isAltDown()) {
                multiplier = 10;
            } else if (e.isShiftDown() || e.isAltDown()) {
                multiplier = 5;
            }
            if (dx != 0 || dy != 0) {
                int size = Math.min(325, Math.min(ColorPickerPanel.this.getWidth() - ColorPickerPanel.this.imagePadding.left - ColorPickerPanel.this.imagePadding.right, ColorPickerPanel.this.getHeight() - ColorPickerPanel.this.imagePadding.top - ColorPickerPanel.this.imagePadding.bottom));
                int offsetX = ColorPickerPanel.this.getWidth() / 2 - size / 2;
                int offsetY = ColorPickerPanel.this.getHeight() / 2 - size / 2;
                ColorPickerPanel.this.mouseListener.mousePressed(new MouseEvent(ColorPickerPanel.this, 501, System.currentTimeMillis(), 0, ((ColorPickerPanel)ColorPickerPanel.this).point.x + multiplier * dx + offsetX, ((ColorPickerPanel)ColorPickerPanel.this).point.y + multiplier * dy + offsetY, 1, false));
            }
        }
    };
    FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            ColorPickerPanel.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ColorPickerPanel.this.repaint();
        }
    };
    ComponentListener componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            ColorPickerPanel.this.regeneratePoint();
            ColorPickerPanel.this.regenerateImage();
        }
    };
    BufferedImage image = new BufferedImage(325, 325, 2);
    Insets imagePadding = new ScaledInsets(6, 6, 6, 6);
    private int[] row = new int[325];

    public ColorPickerPanel() {
        this.setMaximumSize(new Dimension(325 + this.imagePadding.left + this.imagePadding.right, 325 + this.imagePadding.top + this.imagePadding.bottom));
        this.setPreferredSize(new Dimension(243, 243));
        this.setRGB(0, 0, 0);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setFocusable(true);
        this.addKeyListener(this.keyListener);
        this.addFocusListener(this.focusListener);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addComponentListener(this.componentListener);
    }

    public void addChangeListener(ChangeListener l) {
        if (this.changeListeners.contains(l)) {
            return;
        }
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeListeners() {
        if (this.changeListeners == null) {
            return;
        }
        for (int a = 0; a < this.changeListeners.size(); ++a) {
            ChangeListener l = this.changeListeners.get(a);
            try {
                l.stateChanged(new ChangeEvent(this));
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Rectangle r;
        RectangularShape shape;
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        int size = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        g2.translate(this.getWidth() / 2 - size / 2, this.getHeight() / 2 - size / 2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.mode == 2 || this.mode == 1) {
            shape = new Ellipse2D.Float(0.0f, 0.0f, size, size);
        } else {
            r = new Rectangle(0, 0, size, size);
            shape = r;
        }
        g2.drawImage(this.image, 0, 0, size, size, 0, 0, size, size, null);
        g2.setStroke(new BasicStroke(1.0f));
        if (shape instanceof Rectangle) {
            r = (Rectangle)shape;
            PlafPaintUtils.drawBevel(g2, r);
        } else {
            g2.setColor(SHStyle.BORDER_COLOR);
            g2.draw(shape);
        }
        g2.setColor(Color.white);
        g2.setStroke(new BasicStroke(1.0f));
        g2.draw(new Ellipse2D.Float(this.point.x - 3, this.point.y - 3, 6.0f, 6.0f));
        g2.setColor(Color.black);
        g2.draw(new Ellipse2D.Float(this.point.x - 4, this.point.y - 4, 8.0f, 8.0f));
        g.translate(-this.imagePadding.left, -this.imagePadding.top);
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 2 && mode != 1 && mode != 3 && mode != 4 && mode != 5) {
            throw new IllegalArgumentException("The mode must be HUE, SAT, BRI, RED, GREEN, or BLUE.");
        }
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.regenerateImage();
        this.regeneratePoint();
    }

    public void setRGB(int r, int g, int b) {
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("The red value (" + r + ") must be between [0,255].");
        }
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("The green value (" + g + ") must be between [0,255].");
        }
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("The blue value (" + b + ") must be between [0,255].");
        }
        if (this.red != r || this.green != g || this.blue != b) {
            if (this.mode == 3 || this.mode == 4 || this.mode == 5) {
                int lastR = this.red;
                int lastG = this.green;
                int lastB = this.blue;
                this.red = r;
                this.green = g;
                this.blue = b;
                if (this.mode == 3) {
                    if (lastR != r) {
                        this.regenerateImage();
                    }
                } else if (this.mode == 4) {
                    if (lastG != g) {
                        this.regenerateImage();
                    }
                } else if (this.mode == 5 && lastB != b) {
                    this.regenerateImage();
                }
            } else {
                float[] hsb = new float[3];
                Color.RGBtoHSB(r, g, b, hsb);
                this.setHSB(hsb[0], hsb[1], hsb[2]);
                return;
            }
            this.regeneratePoint();
            this.repaint();
            this.fireChangeListeners();
        }
    }

    public float[] getHSB() {
        return new float[]{this.hue, this.sat, this.bri};
    }

    public int[] getRGB() {
        return new int[]{this.red, this.green, this.blue};
    }

    public float[] getHSB(Point p) {
        if (this.mode == 3 || this.mode == 4 || this.mode == 5) {
            int[] rgb = this.getRGB(p);
            float[] hsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
            return hsb;
        }
        int size = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        p.translate(-(this.getWidth() / 2 - size / 2), -(this.getHeight() / 2 - size / 2));
        if (this.mode == 1 || this.mode == 2) {
            double radius = (double)size / 2.0;
            double x = p.getX() - (double)size / 2.0;
            double y = p.getY() - (double)size / 2.0;
            double r = Math.sqrt(x * x + y * y) / radius;
            double theta = Math.atan2(y, x) / (Math.PI * 2);
            if (r > 1.0) {
                r = 1.0;
            }
            if (this.mode == 1) {
                return new float[]{(float)(theta + 0.25), (float)r, this.bri};
            }
            return new float[]{(float)(theta + 0.25), this.sat, (float)r};
        }
        float s = (float)p.x / (float)size;
        float b = (float)p.y / (float)size;
        if (s < 0.0f) {
            s = 0.0f;
        }
        if (s > 1.0f) {
            s = 1.0f;
        }
        if (b < 0.0f) {
            b = 0.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        return new float[]{this.hue, s, b};
    }

    public int[] getRGB(Point p) {
        if (this.mode == 1 || this.mode == 2 || this.mode == 0) {
            float[] hsb = this.getHSB(p);
            int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            return new int[]{r, g, b};
        }
        int size = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        p.translate(-(this.getWidth() / 2 - size / 2), -(this.getHeight() / 2 - size / 2));
        int x2 = p.x * 255 / size;
        int y2 = p.y * 255 / size;
        if (x2 < 0) {
            x2 = 0;
        }
        if (x2 > 255) {
            x2 = 255;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (y2 > 255) {
            y2 = 255;
        }
        if (this.mode == 3) {
            return new int[]{this.red, x2, y2};
        }
        if (this.mode == 4) {
            return new int[]{x2, this.green, y2};
        }
        return new int[]{x2, y2, this.blue};
    }

    public void setHSB(float h, float s, float b) {
        h = (float)((double)h - Math.floor(h));
        if (s < 0.0f || s > 1.0f) {
            throw new IllegalArgumentException("The saturation value (" + s + ") must be between [0,1]");
        }
        if (b < 0.0f || b > 1.0f) {
            throw new IllegalArgumentException("The brightness value (" + b + ") must be between [0,1]");
        }
        if (this.hue != h || this.sat != s || this.bri != b) {
            if (this.mode == 0 || this.mode == 1 || this.mode == 2) {
                float lastHue = this.hue;
                float lastBri = this.bri;
                float lastSat = this.sat;
                this.hue = h;
                this.sat = s;
                this.bri = b;
                if (this.mode == 0) {
                    if (lastHue != this.hue) {
                        this.regenerateImage();
                    }
                } else if (this.mode == 2) {
                    if (lastSat != this.sat) {
                        this.regenerateImage();
                    }
                } else if (this.mode == 1 && lastBri != this.bri) {
                    this.regenerateImage();
                }
            } else {
                Color c = new Color(Color.HSBtoRGB(h, s, b));
                this.setRGB(c.getRed(), c.getGreen(), c.getBlue());
                return;
            }
            Color c = new Color(Color.HSBtoRGB(this.hue, this.sat, this.bri));
            this.red = c.getRed();
            this.green = c.getGreen();
            this.blue = c.getBlue();
            this.regeneratePoint();
            this.repaint();
            this.fireChangeListeners();
        }
    }

    private void regeneratePoint() {
        int size = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        if (this.mode == 0 || this.mode == 2 || this.mode == 1) {
            if (this.mode == 0) {
                this.point = new Point((int)((double)(this.sat * (float)size) + 0.5), (int)((double)(this.bri * (float)size) + 0.5));
            } else if (this.mode == 2) {
                double theta = (double)(this.hue * 2.0f) * Math.PI - 1.5707963267948966;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                double r = this.bri * (float)size / 2.0f;
                this.point = new Point((int)(r * Math.cos(theta) + 0.5 + (double)size / 2.0), (int)(r * Math.sin(theta) + 0.5 + (double)size / 2.0));
            } else if (this.mode == 1) {
                double theta = (double)(this.hue * 2.0f) * Math.PI - 1.5707963267948966;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                double r = this.sat * (float)size / 2.0f;
                this.point = new Point((int)(r * Math.cos(theta) + 0.5 + (double)size / 2.0), (int)(r * Math.sin(theta) + 0.5 + (double)size / 2.0));
            }
        } else if (this.mode == 3) {
            this.point = new Point((int)((float)(this.green * size) / 255.0f + 0.49f), (int)((float)(this.blue * size) / 255.0f + 0.49f));
        } else if (this.mode == 4) {
            this.point = new Point((int)((float)(this.red * size) / 255.0f + 0.49f), (int)((float)(this.blue * size) / 255.0f + 0.49f));
        } else if (this.mode == 5) {
            this.point = new Point((int)((float)(this.red * size) / 255.0f + 0.49f), (int)((float)(this.green * size) / 255.0f + 0.49f));
        }
    }

    private synchronized void regenerateImage() {
        int size = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        if (this.mode == 1 || this.mode == 2) {
            float bri2 = this.bri;
            float sat2 = this.sat;
            float radius = (float)size / 2.0f;
            float k = 1.2f;
            for (int y = 0; y < size; ++y) {
                float y2 = (float)y - (float)size / 2.0f;
                for (int x = 0; x < size; ++x) {
                    double r;
                    float x2 = (float)x - (float)size / 2.0f;
                    double theta = Math.atan2(y2, x2) - 4.71238898038469;
                    if (theta < 0.0) {
                        theta += Math.PI * 2;
                    }
                    if ((r = Math.sqrt(x2 * x2 + y2 * y2)) <= (double)radius) {
                        float hue2;
                        if (this.mode == 1) {
                            hue2 = (float)(theta / (Math.PI * 2));
                            sat2 = (float)(r / (double)radius);
                        } else {
                            hue2 = (float)(theta / (Math.PI * 2));
                            bri2 = (float)(r / (double)radius);
                        }
                        this.row[x] = Color.HSBtoRGB(hue2, sat2, bri2);
                        if (!(r > (double)(radius - k))) continue;
                        int alpha = (int)(255.0 - 255.0 * (r - (double)radius + (double)k) / (double)k);
                        if (alpha < 0) {
                            alpha = 0;
                        }
                        if (alpha > 255) {
                            alpha = 255;
                        }
                        this.row[x] = this.row[x] & 0xFFFFFF + (alpha << 24);
                        continue;
                    }
                    this.row[x] = 0;
                }
                this.image.getRaster().setDataElements(0, y, size, 1, this.row);
            }
        } else if (this.mode == 0) {
            float hue2 = this.hue;
            for (int y = 0; y < size; ++y) {
                float y2 = (float)y / (float)size;
                for (int x = 0; x < size; ++x) {
                    float x2 = (float)x / (float)size;
                    this.row[x] = Color.HSBtoRGB(hue2, x2, y2);
                }
                this.image.getRaster().setDataElements(0, y, this.image.getWidth(), 1, this.row);
            }
        } else {
            int red2 = this.red;
            int green2 = this.green;
            int blue2 = this.blue;
            for (int y = 0; y < size; ++y) {
                float y2 = (float)y / (float)size;
                for (int x = 0; x < size; ++x) {
                    float x2 = (float)x / (float)size;
                    if (this.mode == 3) {
                        green2 = (int)((double)(x2 * 255.0f) + 0.49);
                        blue2 = (int)((double)(y2 * 255.0f) + 0.49);
                    } else if (this.mode == 4) {
                        red2 = (int)((double)(x2 * 255.0f) + 0.49);
                        blue2 = (int)((double)(y2 * 255.0f) + 0.49);
                    } else {
                        red2 = (int)((double)(x2 * 255.0f) + 0.49);
                        green2 = (int)((double)(y2 * 255.0f) + 0.49);
                    }
                    this.row[x] = -16777216 + (red2 << 16) + (green2 << 8) + blue2;
                }
                this.image.getRaster().setDataElements(0, y, size, 1, this.row);
            }
        }
        this.repaint();
    }
}

