/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.Window;
import java.lang.reflect.Method;
import utils.progtools.JavaVersionUtil;

public class SafeAwtUtilities {
    public static boolean isSupported() {
        if (JavaVersionUtil.isJava9OrLater()) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void setWindowOpacity(Window window, float opacity) {
        if (JavaVersionUtil.isJava9OrLater()) {
            try {
                Method setOpacity = Window.class.getMethod("setOpacity", Float.TYPE);
                setOpacity.invoke((Object)window, Float.valueOf(opacity));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            try {
                Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                Method method = clazz.getDeclaredMethod("setWindowOpacity", Window.class, Float.TYPE);
                method.invoke(null, window, new Float(opacity));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

