/*
 * Decompiled with CFR 0.152.
 */
package utils.string;

import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Pattern;
import utils.string.SimpleRegex;

public class FastMatch {
    ArrayList<String> matches;
    boolean caseInsensitive = true;

    public FastMatch(String string, boolean caseInsensitive) {
        String[] tmp;
        this.caseInsensitive = caseInsensitive;
        string = string.trim();
        this.matches = new ArrayList();
        for (String block : tmp = string.split("\\*")) {
            if (block.length() <= 0) continue;
            if (caseInsensitive) {
                block = block.toLowerCase();
            }
            this.matches.add(block);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FastMatch[");
        for (String str : this.matches) {
            sb.append(str).append(',');
        }
        sb.setLength(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    public boolean matchesLowercase(String testLowercase) {
        int index = 0;
        for (int i = 0; i < this.matches.size() && (index = testLowercase.indexOf(this.matches.get(i), index)) != -1; ++i) {
            index += this.matches.get(i).length();
        }
        return index != -1;
    }

    public boolean matches(String test) {
        if (this.caseInsensitive) {
            test = test.toLowerCase();
        }
        int index = 0;
        for (int i = 0; i < this.matches.size() && (index = test.indexOf(this.matches.get(i), index)) != -1; ++i) {
            index += this.matches.get(i).length();
        }
        return index != -1;
    }

    public static void main(String[] args) throws Exception {
        FastMatch match = new FastMatch("*one*two*three*", true);
        System.out.println(match.matches("one two three"));
        System.out.println(match.matches(" one two three "));
        System.out.println(match.matches(" onetwothree "));
        System.out.println(match.matches(" one three two "));
        String[] tests = new String[500];
        Random r = new Random();
        long bytes = 0L;
        for (int i = 0; i < tests.length; ++i) {
            tests[i] = "" + r.nextLong();
            int x = 0;
            while (x < 20) {
                int n = x++;
                tests[n] = tests[n] + r.nextLong();
            }
            bytes += (long)tests[i].length();
        }
        double kb = (double)bytes / 1024.0;
        Pattern pattern = SimpleRegex.simpleToPattern("*one*two*three*", true);
        long count = 0L;
        long T = System.currentTimeMillis();
        while (System.currentTimeMillis() < T + 2000L) {
            for (String test : tests) {
                pattern.matcher(test).matches();
                ++count;
            }
        }
        System.out.println("Regex: " + count);
        double speed = (double)count / (double)tests.length * kb;
        System.out.println("Regex: " + (speed /= 1024.0) + " MB/s");
        FastMatch match2 = new FastMatch("*one*two*three*", true);
        count = 0L;
        T = System.currentTimeMillis();
        while (System.currentTimeMillis() < T + 2000L) {
            for (String test : tests) {
                match2.matches(test);
                ++count;
            }
        }
        System.out.println("FastMatch: " + count);
        speed = (double)count / (double)tests.length * kb;
        System.out.println("FastMatch: " + (speed /= 1024.0) + " MB/s");
    }
}

