/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;
import utils.stream.SelectPoolHandler;
import utils.switches.Switches;

public class SelectPool {
    private static final long NO_ACTIVITY_TIMEOUT = 300000L;
    static boolean VERBOSE = false;
    OnDemandThreadPool odp;
    Selector selector;
    boolean dead = false;
    SelectPoolHandler handler;
    SelectHandler thread;
    final Object selector_LOCK = new Object();
    int max_threads;
    String name;
    boolean autoSetBlocking = true;
    private Random r = new Random();

    public void setAutoSetBlocking(boolean b) {
        this.autoSetBlocking = b;
    }

    public SelectPool(String name, SelectPoolHandler handler) throws IOException {
        this(name, handler, 500);
    }

    public SelectPool(String name, SelectPoolHandler handler, int max_active_threads) throws IOException {
        this.handler = handler;
        this.name = name;
        this.selector = Selector.open();
        this.max_threads = max_active_threads;
        this.odp = new OnDemandThreadPool("SelectPool", max_active_threads, 20000, 5);
        this.thread = new SelectHandler();
        this.thread.start();
    }

    public int getMaxThreads() {
        return this.max_threads;
    }

    public static SelectPool newPoolOrNull(String name, SelectPoolHandler handler) {
        try {
            SelectPool pool = new SelectPool(name, handler);
            return pool;
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    public static SelectPool newPoolOrNull(String name, SelectPoolHandler handler, int max_active_threads) {
        try {
            SelectPool pool = new SelectPool(name, handler, max_active_threads);
            return pool;
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpIntoPool(Socket sock, Object attach) throws IOException {
        SocketChannel channel = sock.getChannel();
        Object object = this.selector_LOCK;
        synchronized (object) {
            if (VERBOSE) {
                System.out.println(this.selector.keys().size() + " selections in pool " + this.name);
            }
            if (VERBOSE) {
                System.out.println("Waking up selector " + System.currentTimeMillis());
            }
            this.selector.wakeup();
            if (Switches.SH_1734_useNioSelectorSingleThreaded) {
                this.thread.toregister.add(new Attached(sock, attach, this.r.nextInt()));
                if (this.thread.toregister.size() >= this.thread.nextWarning) {
                    System.out.println("[SelectPool] ***WARNING*** SelectPool queue of channels is " + this.thread.toregister.size());
                    this.thread.nextWarning *= 2;
                }
            } else {
                this.selector.selectNow();
                if (VERBOSE) {
                    System.out.println("Configuring blocking " + System.currentTimeMillis());
                }
                channel.configureBlocking(false);
                if (VERBOSE) {
                    System.out.println("Registering with selector " + System.currentTimeMillis());
                }
                channel.register(this.selector, 1, new Attached(sock, attach, this.r.nextInt()));
            }
        }
    }

    class Attached {
        Socket socket;
        Object attach;
        int hashcode;

        public Attached(Socket socket, Object attach, int hashcode) {
            this.socket = socket;
            this.attach = attach;
            this.hashcode = hashcode;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    class SelectHandler
    extends Thread
    implements TimeoutMapListener<SelectionKey, SelectionKey> {
        int nextWarning = 1000;
        ArrayList<Attached> toregister = new ArrayList();
        ArrayList<SelectionKey> tocancel = new ArrayList();
        long maxNext = 0L;
        int max = 100;
        TimeoutMap<SelectionKey, SelectionKey> timeouts = new TimeoutMap();

        SelectHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void objectTimedOut(SelectionKey key, SelectionKey val) {
            Object object = SelectPool.this.selector_LOCK;
            synchronized (object) {
                System.out.println("[SelectPool] Timing out " + key);
                this.tocancel.add(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!SelectPool.this.dead) {
                try {
                    SelectPool.this.selector.select(3000L);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
                Object object = SelectPool.this.selector_LOCK;
                synchronized (object) {
                    Iterator<SelectionKey> keys;
                    Attached attached;
                    if (Switches.SH_timeoutNioSelections) {
                        for (SelectionKey skey : this.tocancel) {
                            if (Switches.SH_1778_closeSocketOnSelectTimeout) {
                                try {
                                    attached = (Attached)skey.attachment();
                                    attached.socket.close();
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            try {
                                skey.cancel();
                            }
                            catch (Exception t) {}
                        }
                        this.tocancel.clear();
                    }
                    if (Switches.SH_1734_useNioSelectorSingleThreaded) {
                        try {
                            SelectPool.this.selector.selectNow();
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                        try {
                            for (Attached attached2 : this.toregister) {
                                SocketChannel channel = attached2.socket.getChannel();
                                if (VERBOSE) {
                                    System.out.println("Configuring blocking " + System.currentTimeMillis());
                                }
                                try {
                                    if (channel.isBlocking()) {
                                        channel.configureBlocking(false);
                                    }
                                    if (VERBOSE) {
                                        System.out.println("Registering with selector " + System.currentTimeMillis());
                                    }
                                    SelectionKey key = channel.register(SelectPool.this.selector, 1, attached2);
                                    if (!Switches.SH_timeoutNioSelections) continue;
                                    this.timeouts.put(key, key, 300000L, this);
                                }
                                catch (ClosedChannelException key) {
                                }
                                catch (IOException x) {
                                    x.printStackTrace();
                                }
                            }
                        }
                        finally {
                            this.toregister.clear();
                        }
                    }
                    if (!(keys = SelectPool.this.selector.selectedKeys().iterator()).hasNext()) {
                        if (VERBOSE) {
                            System.out.println("Woken " + System.currentTimeMillis());
                        }
                    } else {
                        if (VERBOSE) {
                            System.out.println("Ready to process " + System.currentTimeMillis());
                        }
                        while (keys.hasNext()) {
                            SelectionKey skey;
                            skey = keys.next();
                            skey.cancel();
                            keys.remove();
                            if (Switches.SH_timeoutNioSelections) {
                                this.timeouts.remove(skey);
                            }
                            attached = (Attached)skey.attachment();
                            try {
                                if (SelectPool.this.autoSetBlocking) {
                                    attached.socket.getChannel().configureBlocking(true);
                                }
                                if (SelectPool.this.odp.runAsync((Runnable)new SelectProcessor(attached))) continue;
                                System.out.println("[SelectPool] Unable to process socket data (pool alert) (" + SelectPool.this.name + ")");
                            }
                            catch (IOException x) {
                                x.printStackTrace();
                            }
                            catch (Throwable x) {
                                x.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }

    class SelectProcessor
    implements Runnable {
        Attached attached;

        public SelectProcessor(Attached attached) {
            this.attached = attached;
        }

        @Override
        public void run() {
            SelectPool.this.handler.process(this.attached.socket, this.attached.attach);
        }
    }
}

