/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedCpuInputStream
extends FilterInputStream {
    InputStream in;
    double PERCENT;
    double FACTOR;

    public LimitedCpuInputStream(InputStream in) {
        this(in, 0.25);
    }

    public LimitedCpuInputStream(InputStream in, double percentCpu) {
        super(in);
        this.in = in;
        this.PERCENT = percentCpu;
        this.FACTOR = (1.0 - this.PERCENT) / this.PERCENT;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        long t = System.currentTimeMillis();
        int n = this.in.read();
        t = System.currentTimeMillis() - t;
        if (this.PERCENT < 1.0) {
            try {
                Thread.sleep(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long t = System.currentTimeMillis();
        int n = this.in.read(b, off, len);
        t = System.currentTimeMillis() - t;
        if (t < 1L) {
            t = 1L;
        }
        t = (long)((double)t * this.FACTOR);
        if (this.PERCENT < 1.0) {
            try {
                Thread.sleep(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return n;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }
}

