/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import utils.stream.CountingStream;

public class CounterOutputStream
extends FilterOutputStream
implements CountingStream {
    volatile long transferred = 0L;

    public CounterOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public long getTransferred() {
        return this.transferred;
    }

    @Override
    public long getTransferredMB() {
        return this.transferred / 1000000L;
    }

    public void reset() {
        this.transferred = 0L;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.transferred += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.transferred;
    }
}

