/*
 * Decompiled with CFR 0.152.
 */
package utils.ssl.letsencrypt;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import utils.ssl.letsencrypt.ChallengeListener;
import utils.ssl.letsencrypt.LEUtils;
import utils.string.Base64URLEncoder;

public final class LetsEncryptRequestor {
    public static final String AGREEMENT_URL = "https://letsencrypt.org/documents/LE-SA-v1.2-November-15-2017.pdf";
    private static final boolean PRODUCTION = true;
    public static final String CHALLENGE_SIMPLE_HTTP = "simpleHttp";
    public static final String CHALLENGE_HTTP_01 = "http-01";
    public static final String CHALLENGE_DNS = "dns";
    private static final String AGREEMENT_KEY = "agreement";
    private static final String STATUS_KEY = "status";
    private static final String STATUS_PENDING = "pending";
    private static final String STATUS_VALID = "valid";
    private static final String CHALLENGE_TLS_KEY = "tls";
    private static final String CHALLENGE_KEY_AUTH = "keyAuthorization";
    private static final String TOKEN_KEY = "token";
    private static final String URI_KEY = "uri";
    private static final String TLS_KEY = "tls";
    private static final String CHALLENGES_KEY = "challenges";
    private static final String CONTACT_KEY = "contact";
    private static final String CSR_KEY = "csr";
    private static final String HEADER_REPLAY_NONCE = "replay-nonce";
    private static final String IDENTIFIER_KEY = "identifier";
    private static final String TYPE_DNS = "dns";
    private static final String TYPE_KEY = "type";
    private static final String VALUE_KEY = "value";
    private static final String NONCE_KEY = "nonce";
    private static final String RESOURCE_CHALLENGE = "challenge";
    private static final String RESOURCE_KEY = "resource";
    private static final int CREATED = 201;
    private static final int CONFLICT = 409;
    private static final int ACCEPTED = 202;
    private static final int FORBIDDEN = 403;
    private static final String SIG_ALG = "RS256";
    private static final String RESOURCE_UPDATE_REGISTRATION = "reg";
    private static final String APPLICATION_JSON = "application/json";
    private static final String JSON_WEB_KEY = "jwk";
    private static final String LOCATION = "Location";
    private static final String USER_ALIAS = "letsencryptUserAlias";
    private final KeyStore keyStore;
    private final ChallengeListener challengeListener;
    private final boolean trustAllCertificate;
    private final char[] password;
    public final String URL_NEW_AUTHZ;
    public final String URL_NEW_CERT;
    public final String URL_NEW_REG;
    public final String URL_REVOKE_CERT;
    private static final int USER_KEY_SIZE = 4096;
    private static final int WEBSITE_KEY_SIZE = 2048;
    private final KeyPair uk;
    private final File intermediateCertsFolder;
    private String email;
    private String keystoreAlias;
    private String nextNonce = null;
    private SSLContext sslCtx0;
    private int status;
    private byte[] resBody;
    private Map<String, List<String>> responseHeader = null;

    static X509Certificate newSelfSigned(KeyPair p, String cn) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Date startDate = new Date(System.currentTimeMillis());
        Date expiryDate = new Date(System.currentTimeMillis() + 31536000000L);
        BigInteger serialNumber = BigInteger.valueOf(new Random().nextLong() & Integer.MAX_VALUE);
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        X500Principal dnName = new X500Principal("cn=" + cn);
        certGen.setSerialNumber(serialNumber);
        certGen.setIssuerDN(dnName);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(expiryDate);
        certGen.setSubjectDN(dnName);
        certGen.setPublicKey(p.getPublic());
        certGen.setSignatureAlgorithm("SHA256withRSA");
        X509Certificate cert = certGen.generate(p.getPrivate(), "BC");
        return cert;
    }

    private static KeyStore loadKeyStore(String ksFile, char[] pass) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        File ks_file = new File(ksFile);
        return LetsEncryptRequestor.loadKeyStore(ks_file, pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(File ks_file, char[] pass) throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance("pkcs12");
        if (ks_file.exists()) {
            FileInputStream s = new FileInputStream(ks_file);
            try {
                ks.load(s, pass);
            }
            finally {
                try {
                    if (s != null) {
                        ((InputStream)s).close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        ks.load(null, null);
        return ks;
    }

    static KeyPair getKeyPair(KeyStore keyStore, String ali, String cn, char[] pass, int keySize) throws NoSuchAlgorithmException, InvalidKeyException, KeyStoreException, CertificateException, NoSuchProviderException, SignatureException, IOException, UnrecoverableKeyException {
        RSAPrivateCrtKey k = (RSAPrivateCrtKey)keyStore.getKey(ali, pass);
        if (k == null) {
            KeyPairGenerator g = KeyPairGenerator.getInstance("RSA");
            g.initialize(keySize);
            KeyPair p = g.generateKeyPair();
            X509Certificate x509Certificate = LetsEncryptRequestor.newSelfSigned(p, cn);
            keyStore.setKeyEntry(ali, p.getPrivate(), pass, new Certificate[]{x509Certificate});
            return p;
        }
        PublicKey pub = keyStore.getCertificate(ali).getPublicKey();
        return new KeyPair(pub, k);
    }

    private static byte[] toIntegerBytes(BigInteger bigInt) {
        int bitlen = bigInt.bitLength();
        bitlen = bitlen + 7 >> 3 << 3;
        byte[] bigBytes = bigInt.toByteArray();
        if (bigInt.bitLength() % 8 != 0 && bigInt.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int len = bigBytes.length;
        if (bigInt.bitLength() % 8 == 0) {
            startSrc = 1;
            --len;
        }
        int startDst = bitlen / 8 - len;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, len);
        return resizedBytes;
    }

    private static String base64UrlEncode(byte[] v) {
        return Base64URLEncoder.byteArrayToBase64((byte[])v);
    }

    public static TreeMap<String, String> getWebKey(PublicKey publicKey) {
        TreeMap<String, String> key = new TreeMap<String, String>();
        if (publicKey instanceof RSAPublicKey) {
            key.put("kty", "RSA");
            key.put("e", LetsEncryptRequestor.base64UrlEncode(LetsEncryptRequestor.toIntegerBytes(((RSAPublicKey)publicKey).getPublicExponent())));
            key.put("n", LetsEncryptRequestor.base64UrlEncode(LetsEncryptRequestor.toIntegerBytes(((RSAPublicKey)publicKey).getModulus())));
            return key;
        }
        throw new IllegalArgumentException();
    }

    private SSLContext getTrustAllCertificateSSLContext() throws NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, KeyStoreException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(this.keyStore, this.password);
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(kmf.getKeyManagers(), trustAllCerts, new SecureRandom());
        return sc;
    }

    public LetsEncryptRequestor(File intermediateCertsFolder, String dirUrl, KeyStore keyStore, KeyStore userKeyStore, String keystoreAlias, ChallengeListener challengeListener, boolean trustAllCertificate, char[] password, String email) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, IOException, InvalidKeyException, CertificateException, NoSuchProviderException, SignatureException {
        if (challengeListener == null) {
            throw new IllegalArgumentException("ChallengeListener=null");
        }
        this.intermediateCertsFolder = intermediateCertsFolder;
        this.keyStore = keyStore;
        this.password = password;
        this.email = email;
        this.challengeListener = challengeListener;
        this.keystoreAlias = keystoreAlias;
        this.trustAllCertificate = trustAllCertificate;
        this.http("GET", dirUrl, APPLICATION_JSON, null, null);
        String json = new String(this.resBody);
        JSONObject obj = new JSONObject(new JSONTokener(json));
        this.URL_NEW_AUTHZ = obj.optString("new-authz", null);
        this.URL_NEW_CERT = obj.optString("new-cert", null);
        this.URL_NEW_REG = obj.optString("new-reg", null);
        this.URL_REVOKE_CERT = obj.optString("revoke-cert", null);
        this.uk = LetsEncryptRequestor.getKeyPair(userKeyStore, USER_ALIAS, USER_ALIAS, password, 4096);
    }

    private static PKCS10CertificationRequest generateCSR(String mainDomain, String[] commonNames, KeyPair domainKey, String email) throws CertificateException, SignatureException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        X500NameBuilder namebuilder = new X500NameBuilder(X500Name.getDefaultStyle());
        namebuilder.addRDN(BCStyle.CN, mainDomain);
        ArrayList<GeneralName> subjectAltNames = new ArrayList<GeneralName>(1);
        subjectAltNames.add(new GeneralName(2, mainDomain));
        for (String cn : commonNames) {
            subjectAltNames.add(new GeneralName(2, cn));
        }
        GeneralNames subjectAltName = new GeneralNames(subjectAltNames.toArray(new GeneralName[0]));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltName.toASN1Primitive());
        Attribute attribute = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)new DERSet((ASN1Encodable)extGen.generate()));
        PKCS10CertificationRequest kpGen = new PKCS10CertificationRequest("SHA256withRSA", new X500Principal("CN=" + mainDomain), domainKey.getPublic(), (ASN1Set)new DERSet((ASN1Encodable)attribute), domainKey.getPrivate());
        System.out.println("[LERequestor] Verify: " + kpGen.verify());
        return kpGen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadCertificate(File file) throws CertificateException {
        X509Certificate x509Certificate;
        block6: {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            FileInputStream in = new FileInputStream(file);
            try {
                x509Certificate = (X509Certificate)cf.generateCertificate(in);
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            }
            ((InputStream)in).close();
        }
        return x509Certificate;
    }

    private static boolean validateChain(X509Certificate[] certChain) {
        int count1 = certChain.length;
        int count0 = count1 - 1;
        for (int c0 = 0; c0 < count0; ++c0) {
            X500Principal issuerDN = certChain[c0].getIssuerX500Principal();
            int c1 = c0 + 1;
            if (c1 < count1) {
                X500Principal subjectDN = certChain[c1].getSubjectX500Principal();
                System.out.println("[LERequestor] Comparing:");
                System.out.println("\t" + issuerDN);
                System.out.println("\t" + subjectDN);
                if (issuerDN.equals(subjectDN)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private X509Certificate extractCertificate(String alias, String domain, InputStream inputStream) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(inputStream);
        System.out.println("[LERequestor] Got certificate: ");
        System.out.println(certificate);
        System.out.println("[LERequestor] -------------------------");
        Key key = this.keyStore.getKey(this.keystoreAlias, this.password);
        System.out.println("[LERequestor] Extracted key: " + key);
        X509Certificate root = LetsEncryptRequestor.loadCertificate(new File(this.intermediateCertsFolder, "le_certificates/IdenTrust/root.crt"));
        X509Certificate int1 = LetsEncryptRequestor.loadCertificate(new File(this.intermediateCertsFolder, "le_certificates/IdenTrust/intermediate_3.crt"));
        this.keyStore.setKeyEntry(alias, key, this.password, new Certificate[]{certificate, int1, root});
        return certificate;
    }

    private String getAuthorizationRequest(String nextNonce, String domain) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, CertificateException, NoSuchProviderException, IOException {
        TreeMap<String, Object> protect = new TreeMap<String, Object>();
        TreeMap<String, Object> header = new TreeMap<String, Object>();
        TreeMap<String, Object> payload = new TreeMap<String, Object>();
        header.put(JSON_WEB_KEY, LetsEncryptRequestor.getWebKey(this.uk.getPublic()));
        protect.put(NONCE_KEY, nextNonce);
        payload.put(RESOURCE_KEY, "new-authz");
        TreeMap<String, String> identifier = new TreeMap<String, String>();
        identifier.put(TYPE_KEY, "dns");
        identifier.put(VALUE_KEY, domain);
        payload.put(IDENTIFIER_KEY, identifier);
        return LEUtils.signWith(SIG_ALG, this.uk.getPrivate(), header, protect, payload);
    }

    private void getInitialNonce() throws Exception {
        this.http("HEAD", this.URL_NEW_REG, APPLICATION_JSON, null, null);
        this.nextNonce = this.getHeaderString(HEADER_REPLAY_NONCE);
        if (this.nextNonce == null) {
            throw new NullPointerException("nonce=null " + this.responseHeader);
        }
    }

    private String getRegistrationURI(String agreement, String[] contacts) throws Exception {
        if (this.nextNonce == null) {
            throw new NullPointerException("nonce=null");
        }
        if (this.nextNonce == null) {
            throw new NullPointerException("nonce=null");
        }
        TreeMap<String, Object> protect = new TreeMap<String, Object>();
        TreeMap<String, Object> header = new TreeMap<String, Object>();
        TreeMap<String, Object> payload = new TreeMap<String, Object>();
        header.put(JSON_WEB_KEY, LetsEncryptRequestor.getWebKey(this.uk.getPublic()));
        protect.put(NONCE_KEY, this.nextNonce);
        payload.put(RESOURCE_KEY, "new-reg");
        if (contacts != null && contacts.length > 0) {
            payload.put(CONTACT_KEY, contacts);
        }
        if (agreement != null) {
            payload.put(AGREEMENT_KEY, agreement);
        }
        String body = LEUtils.signWith(SIG_ALG, this.uk.getPrivate(), header, protect, payload);
        this.http("POST", this.URL_NEW_REG, APPLICATION_JSON, body, APPLICATION_JSON);
        this.nextNonce = this.getHeaderString(HEADER_REPLAY_NONCE);
        if (this.status != 201 && this.status != 409) {
            throw new Exception("Registration failed. " + this);
        }
        return this.getHeaderString(LOCATION);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChallengeRequest getChallengeUri(String agreement, String[] contacts, String domain, String registrationURI) throws Exception {
        int i;
        this.http("POST", this.URL_NEW_AUTHZ, APPLICATION_JSON, this.getAuthorizationRequest(this.nextNonce, domain), APPLICATION_JSON);
        this.nextNonce = this.getHeaderString(HEADER_REPLAY_NONCE);
        if (this.status == 403) {
            if (agreement == null) throw new Exception("Client unautorized. May need to accept new terms. " + this);
            TreeMap<String, Object> protect = new TreeMap<String, Object>();
            TreeMap<String, Object> header = new TreeMap<String, Object>();
            TreeMap<String, Object> payload = new TreeMap<String, Object>();
            header.put(JSON_WEB_KEY, LetsEncryptRequestor.getWebKey(this.uk.getPublic()));
            protect.put(NONCE_KEY, this.nextNonce);
            payload.put(RESOURCE_KEY, RESOURCE_UPDATE_REGISTRATION);
            if (contacts != null && contacts.length > 0) {
                payload.put(CONTACT_KEY, contacts);
            }
            String body = LEUtils.signWith(SIG_ALG, this.uk.getPrivate(), header, protect, payload);
            this.http("POST", registrationURI, APPLICATION_JSON, body, APPLICATION_JSON);
            this.nextNonce = this.getHeaderString(HEADER_REPLAY_NONCE);
            if (this.status != 202) {
                throw new Exception("Registration failed. " + this);
            }
            this.http("POST", this.URL_NEW_AUTHZ, APPLICATION_JSON, this.getAuthorizationRequest(this.nextNonce, domain), APPLICATION_JSON);
            this.nextNonce = this.getHeaderString(HEADER_REPLAY_NONCE);
            if (this.status != 201) {
                throw new Exception("Client unautorized. May need to accept new terms. " + this);
            }
        } else if (this.status != 201) {
            throw new Exception("Failed to create new authorization request. " + this);
        }
        String json = new String(this.resBody);
        JSONObject obj = new JSONObject(new JSONTokener(json));
        System.out.println("[LERequestor] Listing all challenges:");
        JSONArray challenges = obj.getJSONArray(CHALLENGES_KEY);
        for (i = 0; i < challenges.length(); ++i) {
            String challengeType = challenges.getJSONObject(i).optString(TYPE_KEY, null);
            System.out.println("[LERequestor] \tChallenge: " + challengeType);
        }
        for (i = 0; i < challenges.length(); ++i) {
            String challengeTLS;
            String cURI;
            String challengeToken;
            String challengeType;
            ChallengeRequest result;
            String challengeStatus = challenges.getJSONObject(i).optString(STATUS_KEY);
            if (!STATUS_PENDING.equals(challengeStatus) || (result = this.handleChallenge(domain, challengeType = challenges.getJSONObject(i).optString(TYPE_KEY, null), challengeToken = challenges.getJSONObject(i).optString(TOKEN_KEY, null), cURI = challenges.getJSONObject(i).optString(URI_KEY, null), Boolean.valueOf(challengeTLS = challenges.getJSONObject(i).optString("tls", null)))) == null) continue;
            return result;
        }
        throw new Exception("No challenge completed.");
    }

    private void verifyChallenge(ChallengeRequest request) throws Exception {
        TreeMap<String, Object> protect = new TreeMap<String, Object>();
        TreeMap<String, Object> header = new TreeMap<String, Object>();
        TreeMap<String, Object> payload = new TreeMap<String, Object>();
        header.put(JSON_WEB_KEY, LetsEncryptRequestor.getWebKey(this.uk.getPublic()));
        protect.put(NONCE_KEY, this.nextNonce);
        payload.put(RESOURCE_KEY, RESOURCE_CHALLENGE);
        payload.put(TYPE_KEY, request.type);
        payload.put("tls", true);
        payload.put(CHALLENGE_KEY_AUTH, request.content);
        payload.put(TOKEN_KEY, request.token);
        String body = LEUtils.signWith(SIG_ALG, this.uk.getPrivate(), header, protect, payload);
        this.http("POST", request.challengeURI, APPLICATION_JSON, body, APPLICATION_JSON);
        this.nextNonce = this.getHeaderString(HEADER_REPLAY_NONCE);
        if (this.status != 202) {
            throw new Exception("Failed to post challenge. " + this);
        }
    }

    protected String getHTTP01ChallengeContent(KeyPair userKey, String token) {
        return token + "." + LetsEncryptRequestor.getWebKeyThumbprintSHA256(userKey.getPublic());
    }

    public static String getWebKeyThumbprintSHA256(PublicKey publicKey) {
        try {
            TreeMap<String, String> webKey = LetsEncryptRequestor.getWebKey(publicKey);
            String webKeyJson = JSONObject.valueToString(webKey);
            byte[] sha256_2 = LetsEncryptRequestor.SHA256(webKeyJson);
            String ours = LEUtils.base64UrlEncode(sha256_2);
            return ours;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] SHA256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StandardCharsets.UTF_8), 0, text.length());
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForVerification(String challengeURI, String domain) throws Exception {
        int validateChallengeRetryCount = 12;
        while (--validateChallengeRetryCount > 0) {
            Thread.sleep(10000L);
            this.http("GET", challengeURI, APPLICATION_JSON, null, null);
            if (this.status == 202) {
                String json = new String(this.resBody);
                JSONObject obj = new JSONObject(new JSONTokener(json));
                String status = obj.optString(STATUS_KEY, null);
                String type = obj.optString(TYPE_KEY, null);
                String uri = obj.optString(URI_KEY, null);
                String token = obj.optString(TOKEN_KEY, null);
                if (status.equals(STATUS_VALID)) {
                    validateChallengeRetryCount = -1;
                    continue;
                }
                if (status.equals(STATUS_PENDING)) continue;
                this.challengeListener.challengeFailed(domain, "status:" + status + " type:" + type + " uri:" + uri + " token:" + token);
                throw new Exception("Failed verify challenge. Status: " + status + this);
            }
            this.challengeListener.challengeFailed(domain, "HTTP-" + this.status);
            throw new Exception("Failed verify challenge." + this);
        }
        if (validateChallengeRetryCount == 0) {
            this.challengeListener.challengeFailed(domain, "Failed verify challenge. Timeout.");
            throw new Exception("Failed verify challenge. Timeout.");
        }
        this.challengeListener.challengeCompleted(domain);
    }

    private X509Certificate getCertificate(String alias, String domain, PKCS10CertificationRequest csr) throws Exception {
        TreeMap<String, Object> protect = new TreeMap<String, Object>();
        TreeMap<String, Object> header = new TreeMap<String, Object>();
        TreeMap<String, Object> payload = new TreeMap<String, Object>();
        header.put(JSON_WEB_KEY, LetsEncryptRequestor.getWebKey(this.uk.getPublic()));
        protect.put(NONCE_KEY, this.nextNonce);
        payload.put(RESOURCE_KEY, "new-cert");
        payload.put(CSR_KEY, LetsEncryptRequestor.base64UrlEncode(csr.getEncoded()));
        String body = LEUtils.signWith(SIG_ALG, this.uk.getPrivate(), header, protect, payload);
        this.http("POST", this.URL_NEW_CERT, APPLICATION_JSON, body, APPLICATION_JSON);
        if (this.status == 201) {
            if (this.getLength() > 0) {
                return this.extractCertificate(alias, domain, this.getEntity());
            }
            String certificateURL = this.getHeaderString(LOCATION);
            int downloadRetryCount = 12;
            while (downloadRetryCount-- > 0) {
                Thread.sleep(10000L);
                this.http("GET", certificateURL, "*/*", null, null);
                if (this.status == 201) {
                    if (this.getLength() <= 0) continue;
                    return this.extractCertificate(alias, domain, this.getEntity());
                }
                throw new Exception("Failed to download certificate. " + this);
            }
            throw new Exception("Failed to download certificate. Timeout.");
        }
        throw new Exception("Failed to download certificate. " + this);
    }

    public ChallengeRequest getChallengeURI(String domain, String agreement, String[] contacts) throws Exception {
        LetsEncryptRequestor.getKeyPair(this.keyStore, this.keystoreAlias, domain, this.password, 2048);
        if (this.nextNonce == null) {
            this.getInitialNonce();
        }
        String registrationURI = this.getRegistrationURI(agreement, contacts);
        return this.getChallengeUri(agreement, contacts, domain, registrationURI);
    }

    public X509Certificate getCertificate(String alias, String domain, String[] commonNames, ChallengeRequest request) throws Exception {
        if (this.nextNonce == null) {
            this.getInitialNonce();
        }
        this.verifyChallenge(request);
        this.waitForVerification(request.challengeURI, domain);
        PKCS10CertificationRequest csr = LetsEncryptRequestor.generateCSR(domain, commonNames, LetsEncryptRequestor.getKeyPair(this.keyStore, this.keystoreAlias, domain, this.password, 2048), this.email);
        return this.getCertificate(alias, domain, csr);
    }

    private ChallengeRequest handleChallenge(String domain, String challengeType, String token, String challengeURI, boolean tls) throws KeyManagementException, UnrecoverableKeyException, KeyStoreException, Exception {
        if (challengeType.equals(CHALLENGE_SIMPLE_HTTP)) {
            TreeMap<String, Object> protect = new TreeMap<String, Object>();
            TreeMap<String, Object> header = new TreeMap<String, Object>();
            TreeMap<String, Object> payload = new TreeMap<String, Object>();
            payload.put(TYPE_KEY, CHALLENGE_SIMPLE_HTTP);
            payload.put(TOKEN_KEY, token);
            payload.put("tls", true);
            String body = LEUtils.signWith(SIG_ALG, this.uk.getPrivate(), header, protect, payload);
            return this.challengeListener.challengeSimpleHTTP(domain, token, challengeURI, body, tls, this.sslCtx());
        }
        if (challengeType.equals("dvsni")) {
            return this.challengeListener.challengeDVSNI(domain, token, challengeURI, "TODO");
        }
        if (challengeType.equals("dns")) {
            TreeMap<String, Object> protect = new TreeMap<String, Object>();
            TreeMap<String, Object> header = new TreeMap<String, Object>();
            TreeMap<String, Object> payload = new TreeMap<String, Object>();
            payload.put(TYPE_KEY, "dns");
            payload.put(TOKEN_KEY, token);
            String body = LEUtils.signWith(SIG_ALG, this.uk.getPrivate(), header, protect, payload);
            return this.challengeListener.challengeDNS(domain, token, challengeURI, body);
        }
        if (challengeType.equals(CHALLENGE_HTTP_01)) {
            String content = this.getHTTP01ChallengeContent(this.uk, token);
            return this.challengeListener.challengeHTTP01(domain, token, challengeURI, content);
        }
        if (challengeType.equals("tls-sni-01")) {
            return this.challengeListener.challengeTlsSni01(domain, token, challengeURI, "TODO");
        }
        System.out.println("[LERequestor] Unsupported Challenge: " + challengeType);
        return null;
    }

    private SSLContext sslCtx() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        if (this.sslCtx0 == null) {
            this.sslCtx0 = this.trustAllCertificate ? this.getTrustAllCertificateSSLContext() : SSLContext.getInstance("TLSv1.2");
        }
        return this.sslCtx0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void http(String method, String target, String accept, String body, String contentType) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, IOException {
        try {
            URL u = new URL(target);
            HttpURLConnection c = (HttpURLConnection)u.openConnection();
            if (c instanceof HttpsURLConnection) {
                ((HttpsURLConnection)c).setSSLSocketFactory(this.sslCtx().getSocketFactory());
            }
            c.setRequestMethod(method);
            c.setRequestProperty("Accept", accept);
            if ("POST".equals(method)) {
                byte[] bytes = body.getBytes();
                c.setDoOutput(true);
                c.setRequestProperty("Content-Type", contentType);
                c.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                c.setFixedLengthStreamingMode(bytes.length);
                OutputStream s = c.getOutputStream();
                try {
                    s.write(bytes, 0, bytes.length);
                    s.flush();
                }
                finally {
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.status = c.getResponseCode();
            this.responseHeader = c.getHeaderFields();
            InputStream s = this.status < 400 ? c.getInputStream() : c.getErrorStream();
            try {
                if (s == null) {
                    this.resBody = new byte[0];
                } else {
                    this.resBody = new byte[c.getContentLength()];
                    s.read(this.resBody);
                }
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            if (this.status != 201) {
                System.out.println("[LERequestor] " + method + " " + target + " HTTP-" + this.status + " " + c.getResponseMessage() + " " + new String(this.resBody));
            } else {
                System.out.println("[LERequestor] " + method + " " + target + " HTTP-" + this.status + " " + c.getResponseMessage());
            }
        }
        catch (Throwable t) {
            IOException i = new IOException(method + " " + target + " => " + t);
            i.setStackTrace(t.getStackTrace());
            throw i;
        }
    }

    private String getHeaderString(String key) {
        for (Map.Entry<String, List<String>> e : this.responseHeader.entrySet()) {
            if (!key.equalsIgnoreCase(e.getKey())) continue;
            return e.getValue() == null || e.getValue().size() == 0 ? null : e.getValue().get(0);
        }
        return null;
    }

    private int getLength() {
        return this.resBody.length;
    }

    private InputStream getEntity() {
        return new ByteArrayInputStream(this.resBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestCertificate(File intermediateCertsFolder, String email, String domainName, String[] commonNames, File targetKeystore, File userKeystore, String keystoreAlias, char[] keystorePassword, ChallengeListener challengeListener, String agreementURL) throws Exception {
        String baseURL = "https://acme-v01.api.letsencrypt.org/directory";
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        } else {
            new BouncyCastleProvider();
        }
        try {
            KeyStore ks = LetsEncryptRequestor.loadKeyStore(targetKeystore, keystorePassword);
            KeyStore userKeyStore = LetsEncryptRequestor.loadKeyStore(userKeystore, keystorePassword);
            LetsEncryptRequestor leRequestor = new LetsEncryptRequestor(intermediateCertsFolder, baseURL, ks, userKeyStore, keystoreAlias, challengeListener, true, keystorePassword, email);
            LetsEncryptRequestor.getKeyPair(ks, keystoreAlias, domainName, keystorePassword, 2048);
            ChallengeRequest request = leRequestor.getChallengeURI(domainName, agreementURL, new String[]{"mailto:" + email});
            leRequestor.getCertificate(keystoreAlias, domainName, commonNames, request);
            FileOutputStream s = new FileOutputStream(targetKeystore);
            try {
                ks.store(s, keystorePassword);
                s.flush();
            }
            finally {
                try {
                    if (s != null) {
                        ((OutputStream)s).close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception t) {
            targetKeystore.delete();
            throw t;
        }
    }

    public static class ChallengeRequest {
        public String token;
        public String challengeURI;
        public String type;
        public String content;
    }
}

