/*
 * Decompiled with CFR 0.152.
 */
package utils.ssh;

import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import utils.ssh.SSHClient;
import utils.ssh.SSHResponse;

public class RobustSSH {
    boolean log = true;
    String initialpass;
    String rootpass;
    String host;
    int port;
    String loginuser;
    String loginpass;
    File rsaFile;
    String rsaPass;
    long maxwait;
    SSHClient cached;

    public RobustSSH(String host, int port, String loginuser, String loginpass) {
        this.host = host;
        this.port = port;
        this.loginuser = loginuser;
        this.loginpass = loginpass;
    }

    public RobustSSH(String host, int port, String loginuser, File rsaFile, String rsaPass) {
        this.host = host;
        this.port = port;
        this.loginuser = loginuser;
        this.rsaFile = rsaFile;
        this.rsaPass = rsaPass;
    }

    public void close() {
        try {
            if (this.cached != null) {
                this.cached.disconnect();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setLogging(boolean b) {
        this.log = b;
    }

    public void setInitialLoginPass(String pass) {
        this.initialpass = pass;
    }

    public void setRootPass(String pass) {
        this.rootpass = pass;
    }

    private boolean amRoot() {
        return this.loginuser.equals("root");
    }

    private boolean haveRoot() {
        return this.rootpass != null;
    }

    public void grabFile(File local, String remote) throws IOException, JSchException {
        this.grabFile(local.getCanonicalPath(), remote);
    }

    public void pushFile(File local, String remote, String chmodNum) throws IOException, JSchException {
        this.pushFile(local.getCanonicalPath(), remote, chmodNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grabFile(String local, String remote) throws IOException, JSchException {
        if (this.log) {
            System.out.println("[RobustSSH] Pull file " + remote + " to " + local);
        }
        SSHClient ssh = this.createSSHClient();
        try {
            try {
                new File(local).getParentFile().mkdirs();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ssh.scpFrom(remote, local);
            if (this.log) {
                System.out.println("[RobustSSH] Pulled file " + remote + " OK");
            }
        }
        finally {
            ssh.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushFile(String local, String remote, String chmodNum) throws IOException, JSchException {
        if (this.log) {
            System.out.println("[RobustSSH] Push file " + local + " to " + remote);
        }
        SSHClient ssh = this.createSSHClient();
        try {
            String tmpname = "upload" + System.currentTimeMillis() + (int)(1000000.0 * Math.random());
            ssh.scpFile(local, "/tmp/" + tmpname);
            if (this.haveRoot() && !this.amRoot()) {
                SSHResponse resp = ssh.execSudoCommand("/tmp", "mv " + tmpname + " " + remote, this.rootpass);
                resp = ssh.execSudoCommand("/tmp", "chmod " + chmodNum + " " + remote, this.rootpass);
            } else {
                SSHResponse resp = ssh.execCommand("/tmp", "mv " + tmpname + " " + remote);
                resp = ssh.execCommand("/tmp", "chmod " + chmodNum + " " + remote);
            }
        }
        finally {
            ssh.disconnect();
        }
    }

    public String pushScript(String data, String remote) throws IOException, JSchException {
        File file = File.createTempFile("RobustSSH", "script");
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(data.getBytes(StandardCharsets.UTF_8));
        fout.close();
        this.pushFile(file, remote, "755");
        file.delete();
        return remote;
    }

    public SSHResponse runscriptsudo(String cd, String script, String reason) throws JSchException, IOException {
        if (this.amRoot()) {
            return this.runscript(cd, script, reason);
        }
        if (this.log) {
            System.out.println("[RobustSSH] Run sudo script \"" + reason + "\": (" + cd + ") " + script);
        }
        if (!cd.endsWith("/")) {
            cd = cd + "/";
        }
        String remote = cd + "rbsshScript" + System.currentTimeMillis() + ".sh";
        this.pushScript(script, remote);
        SSHResponse resp = this.runsudo(cd, remote, reason);
        this.runsudo(cd, "rm -f \"" + remote + "\"", reason);
        return resp;
    }

    public SSHResponse runscript(String cd, String script, String reason) throws JSchException, IOException {
        if (this.log) {
            System.out.println("[RobustSSH] Run script \"" + reason + "\": (" + cd + ") " + script);
        }
        if (!cd.endsWith("/")) {
            cd = cd + "/";
        }
        String remote = cd + "rbsshScript" + System.currentTimeMillis() + ".sh";
        this.pushScript(script, remote);
        SSHResponse resp = this.run(cd, remote, reason);
        this.run(cd, "rm -f \"" + remote + "\"", reason);
        return resp;
    }

    public SSHResponse runsudo(String cd, String command, String reason) throws JSchException, IOException {
        if (this.amRoot()) {
            return this.run(cd, command, reason);
        }
        if (this.rootpass == null) {
            throw new IOException("Root password not set!");
        }
        if (this.log) {
            System.out.println("[RobustSSH] Run sudo \"" + reason + "\": (" + cd + ") " + command);
        }
        return this.getSSH().execSudoCommand(cd, command, this.rootpass);
    }

    public SSHResponse run(String cd, String command, String reason) throws JSchException, IOException {
        if (this.log) {
            System.out.println("[RobustSSH] Run \"" + reason + "\": (" + cd + ") " + command);
        }
        return this.getSSH().execCommand(cd, command);
    }

    public SSHResponse chmod(String file, String chmodNum, String reason) throws JSchException, IOException {
        if (this.haveRoot()) {
            return this.runsudo("/tmp", "chmod -R " + chmodNum + " \"" + file + "\"", reason);
        }
        return this.run("/tmp", "chmod -R " + chmodNum + " \"" + file + "\"", reason);
    }

    public void setMaxWait(long t) {
        this.maxwait = t;
    }

    private SSHClient getSSH() throws JSchException, IOException {
        if (this.cached == null) {
            this.cached = this.createSSHClient();
        }
        this.cached.setMaxWait(this.maxwait);
        return this.cached;
    }

    private SSHClient createSSHClient() throws JSchException, IOException {
        if (this.rsaFile != null) {
            SSHClient client = new SSHClient(this.host, this.port, this.loginuser, this.rsaFile, this.rsaPass);
            SSHClient.setPrintCommands(false);
            SSHClient.setPrintActivity(false);
            client.setMaxWait(2000L);
            return client;
        }
        if (this.initialpass != null) {
            int attempt = 0;
            SSHClient ssh = new SSHClient(this.host, this.port, this.loginuser, this.initialpass);
            SSHClient.setPrintCommands(false);
            SSHClient.setPrintActivity(false);
            while (true) {
                ++attempt;
                System.out.println("[LinuxSSH] Changing existing password...");
                ssh.handleInitialPasswordChange(this.initialpass, this.loginpass);
                try {
                    System.out.println("[LinuxSSH] Attempting to log in with new password");
                    ssh = new SSHClient(this.host, this.port, this.loginuser, this.loginpass);
                    return ssh;
                }
                catch (Exception x) {
                    System.out.println("[LinuxSSH] Password change seems to have had an issue, retrying login with old password");
                    ssh = new SSHClient(this.host, this.port, this.loginuser, this.initialpass);
                    if (attempt < 5) continue;
                    throw new IOException("Unable to reset password");
                }
                break;
            }
        }
        SSHClient client = new SSHClient(this.host, this.port, this.loginuser, this.loginpass);
        SSHClient.setPrintCommands(false);
        SSHClient.setPrintActivity(false);
        client.setMaxWait(2000L);
        return client;
    }
}

