/*
 * Decompiled with CFR 0.152.
 */
package utils.sound;

import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class SoundConfiguration {
    public static Mixer[] getLineInMixerOptions(AudioFormat format) {
        ArrayList<Mixer> mixers = new ArrayList<Mixer>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfos.length; ++i) {
            Mixer.Info info = mixerInfos[i];
            Mixer m = AudioSystem.getMixer(info);
            Mixer.Info mixerInfo = m.getMixerInfo();
            System.out.println("[SoundConfiguration] Found mixer " + mixerInfo.getName() + " (" + mixerInfo.getDescription() + ")");
            TargetDataLine line = SoundConfiguration.getLineInFromMixer(m, format);
            if (line == null) continue;
            mixers.add(m);
        }
        Mixer[] results = new Mixer[mixers.size()];
        mixers.toArray(results);
        return results;
    }

    public static Mixer[] getLineOutMixerOptions(AudioFormat format) {
        ArrayList<Mixer> mixers = new ArrayList<Mixer>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfos.length; ++i) {
            Mixer.Info info = mixerInfos[i];
            Mixer m = AudioSystem.getMixer(info);
            Mixer.Info mixerInfo = m.getMixerInfo();
            System.out.println("[SoundConfiguration] Found mixer " + mixerInfo.getName() + " (" + mixerInfo.getDescription() + ")");
            SourceDataLine line = SoundConfiguration.getLineOutFromMixer(m, format);
            if (line == null) continue;
            mixers.add(m);
        }
        Mixer[] results = new Mixer[mixers.size()];
        mixers.toArray(results);
        return results;
    }

    public static SourceDataLine getLineOut(AudioFormat format) {
        Mixer[] lineOutMixerOptions = SoundConfiguration.getLineOutMixerOptions(format);
        if (lineOutMixerOptions != null && lineOutMixerOptions.length > 0) {
            return SoundConfiguration.getLineOutFromMixer(lineOutMixerOptions[0], format);
        }
        return null;
    }

    public static TargetDataLine getLineInFromMixer(Mixer mixer, AudioFormat format) {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        try {
            return (TargetDataLine)mixer.getLine(info);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static SourceDataLine getLineOutFromMixer(Mixer mixer, AudioFormat format) {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            return (SourceDataLine)mixer.getLine(info);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static AudioFormat getDefaultAudioFormat() {
        float sampleRate = 8000.0f;
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        AudioFormat format = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        return format;
    }

    public static int getBufferSize(AudioFormat format) {
        return (int)format.getSampleRate() * format.getFrameSize() / 50;
    }
}

