/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.streams;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    private final RandomAccessFile raFile;
    private File file;

    public RandomAccessFileInputStream(File file) throws FileNotFoundException {
        this.file = file;
        this.raFile = new RandomAccessFile(file, "r");
    }

    public void seek(long pos) throws IOException {
        this.raFile.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.raFile.getFilePointer();
    }

    @Override
    public int read() throws IOException {
        return this.raFile.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raFile.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raFile.read(b);
    }

    @Override
    public void close() throws IOException {
        this.raFile.close();
    }
}

