/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.Random;

public class XorShiftRandom {
    long x = System.currentTimeMillis();

    public XorShiftRandom() {
        this(System.currentTimeMillis());
    }

    public XorShiftRandom(long seed) {
        this.x = seed == 0L ? -123456L : seed;
    }

    public long nextLong() {
        this.x ^= this.x << 21;
        this.x ^= this.x >>> 35;
        this.x ^= this.x << 4;
        return this.x;
    }

    public double nextDouble() {
        double d = (double)this.nextLong() / 1.0E17;
        d -= (double)((long)d);
        return Math.abs(d);
    }

    public int nextInt(int max) {
        return (int)(this.nextDouble() * (double)max);
    }

    public long nextLong(long max) {
        return (long)(this.nextDouble() * (double)max);
    }

    public static void main(String[] args) throws Exception {
        int i;
        int i2;
        int N = 0;
        long t = System.currentTimeMillis() + 1000L;
        Object r = new Random(1L);
        while (System.currentTimeMillis() < t) {
            for (i2 = 0; i2 < 100; ++i2) {
                ((Random)r).nextInt(100000);
            }
            N += 100;
        }
        System.out.println("java.utils.Random = " + N);
        N = 0;
        t = System.currentTimeMillis() + 1000L;
        r = new XorShiftRandom(0L);
        for (i2 = 0; i2 < 20; ++i2) {
            System.out.println(((XorShiftRandom)r).nextDouble());
        }
        while (System.currentTimeMillis() < t) {
            for (i2 = 0; i2 < 100; ++i2) {
                ((XorShiftRandom)r).nextInt(100000);
            }
            N += 100;
        }
        int[] choices = new int[100];
        for (i = 0; i < 100000; ++i) {
            int n = ((XorShiftRandom)r).nextInt(choices.length);
            choices[n] = choices[n] + 1;
        }
        System.out.println("Distribution test...");
        for (i = 0; i < choices.length; ++i) {
            System.out.println("Choices[" + i + "] = " + choices[i]);
        }
        System.out.println("XORShift          = " + N);
    }
}

