/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import javax.swing.SwingUtilities;
import utils.progtools.StackDumper;

public class UIDeadlockDetector {
    private static final int CHECK_INTERVAL = 10000;
    private static final int TIMEOUT = 15000;
    private static DeadlockDetector INSTANCE = null;
    private static final Object LOCK = new Object();
    public static final Runnable STACKDUMP_ACTION = new Runnable(){

        @Override
        public void run() {
            System.out.println("[UIDeadlockDetector] Deadlock / delay detected in the UI thread.");
            StackDumper.dumpCondensedCompleteThreadStacks();
        }
    };
    private static long timestamp;
    static Runnable timestampUpdater;

    private UIDeadlockDetector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(Runnable deadlockAction) {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new DeadlockDetector(deadlockAction);
                INSTANCE.start();
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        UIDeadlockDetector.start(STACKDUMP_ACTION);
        Thread.sleep(20000L);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static {
        timestampUpdater = new Runnable(){

            @Override
            public void run() {
                timestamp = System.currentTimeMillis();
            }
        };
    }

    static class DeadlockDetector
    extends Thread {
        long deadlockTime = 0L;
        private Runnable deadlockAction;

        public DeadlockDetector(Runnable deadlockAction) {
            super("DeadlockDetector");
            this.deadlockAction = deadlockAction;
            timestamp = System.currentTimeMillis();
        }

        @Override
        public void run() {
            while (true) {
                SwingUtilities.invokeLater(timestampUpdater);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (System.currentTimeMillis() - timestamp <= 15000L || this.deadlockTime == timestamp) continue;
                this.deadlockTime = timestamp;
                this.deadlockAction.run();
            }
        }
    }
}

