/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import utils.progtools.Counter;
import utils.progtools.MapOfLists;

public class StackDumper {
    public static void requestDelayedDump(final long delayMs) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delayMs);
                    StackDumper.dumpCondensedCompleteThreadStacks();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public static void dumpCondensedCompleteThreadStacks() {
        StackDumper.dumpCondensedCompleteThreadStacks(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCondensedCompleteThreadStacks(File save) {
        block16: {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PrintStream pout = new PrintStream(bout);
                Method method = Thread.class.getMethod("getAllStackTraces", new Class[0]);
                Map map = (Map)method.invoke(null, new Object[0]);
                Thread[] threadKeys = map.keySet().toArray(new Thread[0]);
                pout.println("[AllThreadsTrace] Full Thread Trace Printout " + new Date());
                pout.println("[AllThreadsTrace] Total Threads: x" + threadKeys.length);
                MapOfLists byTrace = new MapOfLists(true);
                Counter sorter = new Counter();
                for (Thread th : threadKeys) {
                    StackTraceElement[] stack = (StackTraceElement[])map.get(th);
                    StringBuilder stacks = new StringBuilder();
                    for (StackTraceElement aStack : stack) {
                        stacks.append("\tat ").append(aStack).append("\n");
                    }
                    String tstak = stacks.toString();
                    byTrace.add((Object)tstak, (Object)th);
                    sorter.add((Object)tstak, 1.0);
                }
                sorter.sortByValue(false);
                ArrayList keylist = sorter.getSortedKeys();
                for (String tstak : keylist) {
                    List all = byTrace.get((Object)tstak);
                    pout.println();
                    pout.println();
                    pout.println("[AllThreadsTrace] " + all.size() + "x threads with trace:");
                    pout.println(tstak);
                    pout.println("   Thread Names:");
                    Collections.sort(all, new Comparator<Thread>(){

                        @Override
                        public int compare(Thread o1, Thread o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    for (int k = 0; k < all.size(); ++k) {
                        Thread th = (Thread)all.get(k);
                        if (k > 0) {
                            pout.print(",");
                        }
                        if (k == 0) {
                            pout.print("   ");
                        } else if (k % 3 == 0) {
                            pout.println();
                            pout.print("   ");
                        } else {
                            pout.print(" ");
                        }
                        pout.print(th.getName() + " (" + (Object)((Object)th.getState()) + ") [#" + th.getId() + "]");
                    }
                    pout.println();
                }
                try {
                    StackDumper.dumpDeadlockDetails(pout);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                pout.flush();
                String text = new String(bout.toByteArray());
                System.out.println(text);
                if (save == null) break block16;
                try (BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(save));){
                    ((OutputStream)fout).write(bout.toByteArray());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static void dumpDeadlockDetails(PrintStream pout) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] deadlock = threadMXBean.findDeadlockedThreads();
        if (deadlock != null && deadlock.length > 0) {
            ThreadInfo[] threadInfos;
            pout.println();
            pout.println();
            pout.println("[DeadlockDetails]");
            pout.println();
            for (ThreadInfo info : threadInfos = threadMXBean.getThreadInfo(deadlock, true, true)) {
                pout.println("\t" + info.getThreadName() + " (BLOCKED) [#" + info.getThreadId() + "]:");
                pout.println("\t\twaiting for: " + info.getLockName());
                pout.println("\t\towned by: " + info.getLockOwnerName() + " [#" + info.getLockOwnerId() + "]");
                MonitorInfo[] lockedMonitors = info.getLockedMonitors();
                String last = null;
                for (MonitorInfo lockedMonitor : lockedMonitors) {
                    String newLine = lockedMonitor.getLockedStackFrame() + " (line " + lockedMonitor.getLockedStackDepth() + " in stack trace)";
                    if (last != null && last.equals(newLine)) continue;
                    last = newLine;
                    pout.println("\t\tlocation: " + newLine);
                }
                pout.println();
            }
        }
    }
}

