/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.HashMap;
import java.util.Random;
import utils.progtools.CacheListener;

public class MemoryCache {
    HashMap map = new HashMap();
    LinkedCacheList list = new LinkedCacheList();
    int MAX_SIZE_BYTES = 200000;
    long totalBytes = 0L;
    double hits = 0.0;
    double misses = 0.0;

    public double getTotalRequests() {
        return this.hits + this.misses;
    }

    public double getTotalHits() {
        return this.hits;
    }

    public double getTotalMisses() {
        return this.misses;
    }

    public double getHitRatePercent() {
        return 100.0 * (this.hits / (this.hits + this.misses));
    }

    public MemoryCache() {
    }

    public MemoryCache(int max_size_bytes) {
        this.MAX_SIZE_BYTES = max_size_bytes;
    }

    public void trimAndSetMaxSize(int max_size_bytes) {
        this.MAX_SIZE_BYTES = max_size_bytes;
        this.trim(null);
    }

    private void trim(CacheListener listener) {
        while (this.totalBytes > (long)this.MAX_SIZE_BYTES) {
            LinkedEntry rm = this.list.removeFirst();
            if (rm == null) {
                System.out.println("***WARNING mem cache size out of sync (" + this.totalBytes + " / " + this.map.size() + " / 0)");
                this.totalBytes = 0L;
                break;
            }
            this.totalBytes -= rm.sizeInBytes;
            rm.next = null;
            rm.prev = null;
            if (rm == null) continue;
            this.map.remove(rm.valueKey);
            if (listener == null) continue;
            listener.removedFromCache(rm.valueKey, rm.valueValue);
        }
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public void clear() {
        this.map = new HashMap();
        this.list = new LinkedCacheList();
        this.totalBytes = 0L;
    }

    public int maxSizeBytes() {
        return this.MAX_SIZE_BYTES;
    }

    public void addToCache(Object key, Object value, long valueSizeBytes) {
        this.addToCache(key, value, valueSizeBytes, null);
    }

    public void addToCache(Object key, Object value, long valueSizeBytes, CacheListener listener) {
        LinkedEntry e = (LinkedEntry)this.map.get(key);
        if (e == null) {
            this.map.put(key, this.list.add(key, value, valueSizeBytes));
            this.totalBytes += valueSizeBytes;
            this.trim(listener);
        }
    }

    public Object getFromCache(Object key) {
        LinkedEntry e = (LinkedEntry)this.map.get(key);
        if (e == null) {
            this.misses += 1.0;
            return null;
        }
        this.hits += 1.0;
        this.list.moveToFront(e);
        return e.valueValue;
    }

    public static void main(String[] args) throws Exception {
        MemoryCache cache = new MemoryCache(10000);
        Random rand = new Random(5L);
        int hits = 0;
        int misses = 0;
        double COUNT = 2000000.0;
        double t = System.currentTimeMillis();
        int i = 0;
        while ((double)i < COUNT) {
            Integer key = new Integer(rand.nextInt(250));
            String value = (String)cache.getFromCache(key);
            if (value == null) {
                ++misses;
                value = "#" + key;
                cache.addToCache(key, value, 50L);
            } else {
                ++hits;
            }
            ++i;
        }
        t = (double)System.currentTimeMillis() - t;
        System.out.println(hits + " hits");
        System.out.println(misses + " misses");
        System.out.println("Cache size: " + cache.map.size());
        System.out.println(COUNT + " lookups in " + t + "ms");
        System.out.println(t / COUNT + " ms per lookups");
    }

    class LinkedCacheList {
        LinkedEntry start;
        LinkedEntry end;

        LinkedCacheList() {
        }

        public LinkedEntry add(Object key, Object value, long sizeInBytes) {
            LinkedEntry e = new LinkedEntry();
            e.valueKey = key;
            e.valueValue = value;
            e.next = null;
            e.sizeInBytes = sizeInBytes;
            if (this.end == null) {
                this.start = e;
                this.end = e;
                e.prev = null;
            } else {
                this.end.next = e;
                e.prev = this.end;
                this.end = e;
            }
            return e;
        }

        public LinkedEntry removeFirst() {
            if (this.start != null) {
                if (this.start == this.end) {
                    this.end = null;
                }
                LinkedEntry ret = this.start;
                this.start = this.start.next;
                if (this.start != null) {
                    this.start.prev = null;
                }
                return ret;
            }
            return null;
        }

        public void moveToFront(LinkedEntry e) {
            if (e != this.end) {
                if (e == this.start) {
                    this.start = e.next;
                    this.start.prev = null;
                } else {
                    e.prev.next = e.next;
                    e.next.prev = e.prev;
                }
                this.end.next = e;
                e.prev = this.end;
                e.next = null;
                this.end = e;
            }
        }
    }

    class LinkedEntry {
        Object valueKey;
        Object valueValue;
        LinkedEntry prev;
        LinkedEntry next;
        long sizeInBytes;

        LinkedEntry() {
        }

        public String toString() {
            return "" + this.valueKey;
        }
    }
}

