/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

public class LimitedErrorHandler {
    public static final StdoutLimitedErrorRunnable STDOUT_HANDLER = new StdoutLimitedErrorRunnable();
    private final LimitedErrorRunnable handler;
    private final long minPrintoutDurationMS;
    private long printSummaryDurationMS = -1L;
    private long lastTime = -1L;
    private long lastSummartTime = -1L;
    private long errorCount = 0L;

    public LimitedErrorHandler(long minPrintoutDurationMS, LimitedErrorRunnable handler) {
        this.handler = handler;
        this.minPrintoutDurationMS = minPrintoutDurationMS;
    }

    public LimitedErrorHandler(long minPrintoutDurationMS, LimitedErrorRunnable handler, long printSummaryDurationMS) {
        this(minPrintoutDurationMS, handler);
        this.printSummaryDurationMS = printSummaryDurationMS;
    }

    public void handlerError(String error) {
        if (this.shouldHandle()) {
            this.handler.handleError(error);
        }
    }

    public void handlerError(String error, Throwable t) {
        if (this.shouldHandle()) {
            this.handler.handleError(error);
            this.handler.handleException(t);
        }
    }

    public void handleException(Throwable t) {
        if (this.shouldHandle()) {
            this.handler.handleException(t);
        }
    }

    private boolean shouldHandle() {
        ++this.errorCount;
        if (this.printSummaryDurationMS > 0L) {
            if (this.lastSummartTime == -1L) {
                this.lastSummartTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.lastSummartTime > this.printSummaryDurationMS) {
                this.handler.handleSummary(this.errorCount, System.currentTimeMillis() - this.lastSummartTime);
                this.lastSummartTime = System.currentTimeMillis();
                this.errorCount = 0L;
            }
        }
        if (System.currentTimeMillis() - this.lastTime > this.minPrintoutDurationMS) {
            this.lastTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws InterruptedException {
        LimitedErrorHandler handler = new LimitedErrorHandler(1000L, new StdoutLimitedErrorRunnable());
        for (int i = 0; i < 10000; ++i) {
            handler.handlerError("woooot");
            Thread.sleep(1L);
        }
    }

    public static interface LimitedErrorRunnable {
        public void handleError(String var1);

        public void handleException(Throwable var1);

        public void handleSummary(long var1, long var3);
    }

    public static class StdoutLimitedErrorRunnable
    implements LimitedErrorRunnable {
        private String lastError;

        @Override
        public void handleError(String error) {
            this.lastError = error;
            System.out.println(error);
        }

        @Override
        public void handleException(Throwable t) {
            t.printStackTrace();
        }

        @Override
        public void handleSummary(long errorsReported, long durationMS) {
            if (this.lastError != null) {
                System.out.println("[LimitedErrorHandler] Summary " + errorsReported + " errors produced in " + durationMS + " (last error was '" + this.lastError + "')");
            } else {
                System.out.println("[LimitedErrorHandler] Summary " + errorsReported + " errors produced in " + durationMS);
            }
        }
    }
}

