/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.MBeanServer;

public class HeapDumper {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile Object hotspotMBean;
    private static Class beanClass;

    public static String dumpHeap(String fileName, boolean live) {
        if (!fileName.toLowerCase().endsWith(".hprof")) {
            fileName = fileName + ".hprof";
        }
        new File(fileName).delete();
        HeapDumper.initHotspotMBean();
        try {
            Method method = beanClass.getDeclaredMethod("dumpHeap", String.class, Boolean.TYPE);
            method.invoke(hotspotMBean, fileName, live);
            return fileName;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<HeapDumper> clazz = HeapDumper.class;
        synchronized (HeapDumper.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = HeapDumper.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static Object getHotspotMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            beanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, beanClass);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public static void main(String[] args) {
        String fileName = "heap.hprof";
        boolean live = true;
        switch (args.length) {
            case 2: {
                live = args[1].equals("true");
            }
            case 1: {
                fileName = args[0];
            }
        }
        HeapDumper.dumpHeap(fileName, live);
    }
}

