/*
 * Decompiled with CFR 0.152.
 */
package utils.multiplex;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import utils.multiplex.FastBoutBuffer;
import utils.multiplex.MultiplexingInput;
import utils.progtools.IdentiThread;
import utils.stream.OpenBoutPool;
import utils.stream.OpenByteArrayOutputStream;
import utils.stream.StreamUtils;
import utils.sync.UnqueuedMutex;

public class FastMxInputStream
implements MultiplexingInput {
    InputStream instream;
    Object lock = new Object();
    Object notifier = new Object();
    HashMap<Integer, FastBoutBuffer> instreams = new HashMap();
    HashMap locks = new HashMap();
    boolean closed = false;
    IOException ioexception;
    OpenBoutPool pool = new OpenBoutPool(1000, 10240);

    private void checkIoException(String err) throws IOException {
        if (this.ioexception != null) {
            IOException tmp = new IOException(err);
            tmp.initCause(this.ioexception);
            throw tmp;
        }
    }

    public FastMxInputStream(InputStream in) {
        this.instream = new BufferedInputStream(in);
        ReaderThread rthread = new ReaderThread();
        rthread.setDaemon(true);
        rthread.start();
    }

    public FastMxInputStream(InputStream in, String readername) {
        this.instream = new BufferedInputStream(in);
        ReaderThread rthread = new ReaderThread(readername);
        rthread.setDaemon(true);
        rthread.start();
    }

    public FastMxInputStream(InputStream in, String readername, ThreadGroup tg) {
        this.instream = new BufferedInputStream(in);
        ReaderThread rthread = new ReaderThread(tg, readername);
        rthread.setDaemon(true);
        rthread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnqueuedMutex getLock(short n) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            UnqueuedMutex nlock = (UnqueuedMutex)this.locks.get(N);
            if (nlock == null) {
                nlock = new UnqueuedMutex();
                this.locks.put(N, nlock);
            }
            return nlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        this.closed = true;
        Object object = this.lock;
        synchronized (object) {
            Collection<FastBoutBuffer> tmp = this.instreams.values();
            Iterator<FastBoutBuffer> it = tmp.iterator();
            while (it.hasNext()) {
                it.next().setClosed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(IOException e) {
        this.closed = true;
        this.ioexception = e;
        Object object = this.lock;
        synchronized (object) {
            Collection<FastBoutBuffer> tmp = this.instreams.values();
            Iterator<FastBoutBuffer> it = tmp.iterator();
            while (it.hasNext()) {
                it.next().setClosed(e);
            }
        }
    }

    public InputStream getBcuBufInputStream(short n, String name, BCUtil bcu) {
        return new BufferedInputStream((InputStream)new BCUtilInputStream(this.getBufInputStream(n, name), bcu.clone()));
    }

    public InputStream getBufInputStream(short n, String name) {
        return new BufferedInputStream(this.getInputStream(n, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(short n, String name) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            FastBoutBuffer in = this.instreams.get(N);
            if (in == null) {
                in = new FastBoutBuffer(200000, this.pool);
                this.instreams.put(N, in);
            }
            in.setName(name);
            if (this.closed) {
                if (this.ioexception != null) {
                    in.setClosed(this.ioexception);
                } else {
                    in.setClosed();
                }
            }
            return in;
        }
    }

    class ReaderThread
    extends IdentiThread {
        ThreadGroup tg;

        public ReaderThread() {
            this.tg = null;
        }

        public ReaderThread(String name) {
            super(name);
            this.tg = null;
        }

        public ReaderThread(ThreadGroup tg, String name) {
            super(tg, name);
            this.tg = null;
            this.tg = tg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                byte[] buf = new byte[200000];
                while (!FastMxInputStream.this.closed) {
                    boolean compressed = FastMxInputStream.this.instream.read() == 9;
                    InputStream instream = FastMxInputStream.this.instream;
                    OpenByteArrayOutputStream zipper = null;
                    if (compressed) {
                        zipper = (OpenByteArrayOutputStream)FastMxInputStream.this.pool.get();
                        int nbytes = StreamUtils.readInt((InputStream)instream);
                        zipper.pullBytes(instream, buf, nbytes);
                        instream = new GZIPInputStream(new ByteArrayInputStream(zipper.getByteArray(), 0, zipper.size()));
                    }
                    short nstream = StreamUtils.readShort((InputStream)instream);
                    int nbytes = StreamUtils.readInt((InputStream)instream);
                    if (nbytes <= 0) continue;
                    OpenByteArrayOutputStream obout = (OpenByteArrayOutputStream)FastMxInputStream.this.pool.get();
                    while (obout.size() < nbytes) {
                        int n = instream.read(buf, 0, Math.min(buf.length, nbytes - obout.size()));
                        if (n <= 0) continue;
                        obout.write(buf, 0, n);
                    }
                    if (zipper != null) {
                        FastMxInputStream.this.pool.done((Object)zipper);
                    }
                    Integer Nstream = new Integer(nstream);
                    Object object = FastMxInputStream.this.lock;
                    synchronized (object) {
                        FastBoutBuffer in = FastMxInputStream.this.instreams.get(Nstream);
                        if (in == null) {
                            in = new FastBoutBuffer(200000, FastMxInputStream.this.pool);
                            FastMxInputStream.this.instreams.put(Nstream, in);
                        }
                        in.add(obout);
                    }
                }
                return;
            }
            catch (EOFException e) {
                FastMxInputStream.this.closeAll();
                if (this.tg == null) return;
                this.tg.uncaughtException((Thread)((Object)this), e);
                return;
            }
            catch (IOException e) {
                FastMxInputStream.this.closeAll(e);
                if (this.tg == null) return;
                this.tg.uncaughtException((Thread)((Object)this), e);
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
                FastMxInputStream.this.closeAll(new IOException("unknown error " + t));
                if (this.tg == null) return;
                this.tg.uncaughtException((Thread)((Object)this), t);
            }
        }
    }
}

