/*
 * Decompiled with CFR 0.152.
 */
package utils.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.message.ProtectiveDrainNowInstruction;

public class ProtectiveDrain {
    private int DRAIN_1 = -308150289;
    private int DRAIN_2 = -308084753;
    InputStream in;
    OutputStream out;

    public ProtectiveDrain(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    public ProtectiveDrain(InputStream in, OutputStream out, int drainType1, int drainType2) {
        this.in = in;
        this.out = out;
        this.DRAIN_1 = drainType1;
        this.DRAIN_2 = drainType2;
    }

    public void writeMessage(Message m) throws IOException {
        MessageUtils.writeMessage((OutputStream)this.out, (Message)m);
    }

    public Message readMessage() throws IOException, ProtectiveDrainNowInstruction {
        Message m = MessageUtils.readMessage((InputStream)this.in);
        if (m.getType() == this.DRAIN_1) {
            throw new ProtectiveDrainNowInstruction("Remote side has failed, entering recovery protocol");
        }
        return m;
    }

    public void finishWithProtectiveDrain() throws IOException {
        Message m;
        MessageUtils.writeMessage((OutputStream)this.out, (Message)new Message(this.DRAIN_1));
        MessageUtils.writeMessage((OutputStream)this.out, (Message)new Message(this.DRAIN_2));
        while ((m = MessageUtils.readMessage((InputStream)this.in)).getType() != this.DRAIN_2) {
        }
    }
}

