/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import utils.loggingframework.events.LogEvent;
import utils.string.CharStack;

public class VariableUtil {
    public static String getSubstitutedText(String template, LogEvent event) {
        return VariableUtil.getSubstitutedText(template, event, false);
    }

    public static String getSubstitutedText(String template, LogEvent event, boolean removeNewlines) {
        StringBuilder buffer = new StringBuilder();
        CharStack stack = new CharStack(template);
        buffer.append(stack.popUntil("${", true));
        while (!stack.isEmpty()) {
            String value = null;
            String variable = stack.popUntil('}', true);
            if (variable != null && variable.length() > 0) {
                value = event.getValueForVariable(variable.trim());
            }
            if (value == null) {
                value = "N/A";
            }
            if (removeNewlines) {
                value = value.replace("\n", "");
                value = value.replace("\r", "");
            }
            buffer.append(value);
            buffer.append(stack.popUntil("${", true));
        }
        return buffer.toString();
    }

    public static String[] getCommonVariableNames(LogEvent[] events) {
        LogEvent.LogEventVariable[] list = VariableUtil.getCommonVariables(events);
        ArrayList<String> result = new ArrayList<String>();
        for (LogEvent.LogEventVariable var : list) {
            result.add(var.getName());
        }
        return result.toArray(new String[0]);
    }

    public static LogEvent.LogEventVariable[] getCommonVariables(LogEvent[] events) {
        LogEvent.LogEventVariable[] variables;
        if (events == null || events.length == 0) {
            return new LogEvent.LogEventVariable[0];
        }
        ArrayList<LogEvent.LogEventVariable> list = new ArrayList<LogEvent.LogEventVariable>();
        for (LogEvent.LogEventVariable v : variables = events[0].getVariables()) {
            list.add(v);
        }
        for (int i = 1; i < events.length; ++i) {
            variables = events[i].getVariables();
            List<LogEvent.LogEventVariable> newList = Arrays.asList(variables);
            list.retainAll(newList);
            if (list.size() == 0) break;
        }
        return list.toArray(new LogEvent.LogEventVariable[0]);
    }
}

