/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.command.CommandTarget;
import utils.loggingframework.targets.donothing.DoNothing;
import utils.loggingframework.targets.email.EmailTarget;
import utils.loggingframework.targets.file.FileTarget;
import utils.loggingframework.targets.httppost.HTTPPostTarget;

public class TargetRepository {
    public static TargetRepository INSTANCE = new TargetRepository();
    private HashMap<String, Class<? extends AbstractTarget>> idToTargetMap = new HashMap();
    private ArrayList<Class<? extends AbstractTarget>> targetClasses = new ArrayList();

    private TargetRepository() {
        this.addTarget("DoNothing", DoNothing.class);
        this.addTarget("FileTarget", FileTarget.class);
        this.addTarget("EmailTarget", EmailTarget.class);
        this.addTarget("CommandTarget", CommandTarget.class);
        this.addTarget("HTTPPostTarget", HTTPPostTarget.class);
    }

    public void addTarget(String id, Class<? extends AbstractTarget> targetClazz) {
        if (!this.idToTargetMap.containsKey(id)) {
            this.idToTargetMap.put(id, targetClazz);
            this.targetClasses.add(targetClazz);
        }
    }

    public Class<? extends AbstractTarget> getTargetClass(String id) {
        Class<? extends AbstractTarget> result = this.idToTargetMap.get(id);
        if (result == null) {
            System.out.println("[TargetRepository] WARNING: Cannot find target for id " + id);
        }
        return result;
    }

    public AbstractTarget getNewTargetInstance(AbstractTarget targetToClone) {
        try {
            Class<?> clazz = targetToClone.getClass();
            AbstractTarget target = (AbstractTarget)clazz.newInstance();
            target.setBundle(targetToClone.bundle);
            return target;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public AbstractTarget[] getTargetInstances(ResourceBundle bundle) {
        ArrayList<AbstractTarget> result = new ArrayList<AbstractTarget>();
        for (Class<? extends AbstractTarget> targetClass : this.targetClasses) {
            try {
                AbstractTarget target = targetClass.newInstance();
                target.setBundle(bundle);
                result.add(target);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result.toArray(new AbstractTarget[0]);
    }
}

