/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.aggregator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.aggregator.AggregateQueryMetadata;
import utils.dataservice.gziplist.aggregator.AverageAggregator;
import utils.dataservice.gziplist.aggregator.BooleanDurationAggregator;
import utils.dataservice.gziplist.aggregator.BooleanFalseCountAggregator;
import utils.dataservice.gziplist.aggregator.BooleanTrueCountAggregator;
import utils.dataservice.gziplist.aggregator.EnumAggregator;
import utils.dataservice.gziplist.aggregator.MaxAggregator;
import utils.dataservice.gziplist.aggregator.MinAggregator;
import utils.dataservice.gziplist.aggregator.StandardDeviationAggregator;
import utils.dataservice.gziplist.aggregator.SumAggregator;
import utils.stream.StreamUtils;

public abstract class Aggregator {
    boolean subAggregator = false;
    public static final byte SUM = 0;
    public static final byte MIN = 1;
    public static final byte MAX = 2;
    public static final byte AVERAGE = 3;
    public static final byte STANDARD_DEVIATION = 4;
    public static final byte TRUE_COUNT = 10;
    public static final byte FALSE_COUNT = 11;
    public static final byte BOOLEAN_STATE_DURATION = 12;
    public static final byte ENUM_COUNT = 13;
    public static final byte[] ALL_AGGREGATES = new byte[]{0, 1, 2, 3, 4, 10, 11, 12, 13};
    byte aggType = 0;
    int totalChunkSpan = 0;

    public static String getCalcName(int n) {
        switch (n) {
            case 3: {
                return "Average";
            }
            case 1: {
                return "Min";
            }
            case 2: {
                return "Max";
            }
            case 0: {
                return "Sum";
            }
            case 4: {
                return "Standard Deviation";
            }
            case 10: {
                return "True Count";
            }
            case 11: {
                return "False Count";
            }
            case 12: {
                return "Total Duration True";
            }
            case 13: {
                return "Enum Count";
            }
        }
        return "Unknown";
    }

    public static String getShortCalcName(int n) {
        switch (n) {
            case 3: {
                return "Avg";
            }
            case 1: {
                return "Min";
            }
            case 2: {
                return "Max";
            }
            case 0: {
                return "Sum";
            }
            case 4: {
                return "Std Dev";
            }
            case 10: {
                return "Trues";
            }
            case 11: {
                return "Falses";
            }
            case 12: {
                return "True Time";
            }
            case 13: {
                return "Counts";
            }
        }
        return "Unknown";
    }

    public static final Aggregator getAggregator(byte aggregatorType, int chunkSpan, Object previousEvent) {
        boolean subAggregator = false;
        if (chunkSpan == AggregateChunk.AGGREGATE_CHUNK_SPANS[0]) {
            subAggregator = true;
        }
        switch (aggregatorType) {
            case 0: {
                return new SumAggregator(chunkSpan, subAggregator);
            }
            case 1: {
                return new MinAggregator(chunkSpan, subAggregator);
            }
            case 2: {
                return new MaxAggregator(chunkSpan, subAggregator);
            }
            case 3: {
                return new AverageAggregator(chunkSpan, subAggregator);
            }
            case 4: {
                return new StandardDeviationAggregator(chunkSpan, subAggregator);
            }
            case 10: {
                return new BooleanTrueCountAggregator(chunkSpan, subAggregator);
            }
            case 11: {
                return new BooleanFalseCountAggregator(chunkSpan, subAggregator);
            }
            case 12: {
                return new BooleanDurationAggregator(chunkSpan, subAggregator, previousEvent);
            }
            case 13: {
                return new EnumAggregator(chunkSpan, subAggregator);
            }
        }
        System.out.println("NULL AGGREGATOR TYPE VAL = " + aggregatorType);
        return null;
    }

    public static Object getAggregatorValue(byte aggregatorType, Object[] results) {
        for (int i = 0; i < ALL_AGGREGATES.length; ++i) {
            if (ALL_AGGREGATES[i] != aggregatorType) continue;
            return results[i];
        }
        return null;
    }

    public void toStream(OutputStream outStream) throws IOException {
        outStream.write(this.aggType);
        StreamUtils.writeInt((OutputStream)outStream, (int)this.totalChunkSpan);
        this.writeToStream(outStream);
    }

    public static Aggregator fromStream(InputStream inStream) throws IOException {
        byte aggType = (byte)inStream.read();
        int chunkSpan = StreamUtils.readInt((InputStream)inStream);
        Aggregator agg = Aggregator.getAggregator(aggType, chunkSpan, null);
        agg.readFromStream(inStream);
        return agg;
    }

    protected Aggregator(byte aggType, int chunkSpan, boolean subAggregator) {
        this.subAggregator = subAggregator;
        this.aggType = aggType;
        this.totalChunkSpan = chunkSpan;
    }

    public int getChunkSpan() {
        return this.totalChunkSpan;
    }

    public byte getAggregatorType() {
        return this.aggType;
    }

    public abstract void readFromStream(InputStream var1) throws IOException;

    public abstract void writeToStream(OutputStream var1) throws IOException;

    public abstract Object getValue();

    public abstract void reset();

    public abstract void addValue(double var1, Object var3, double var4, Object var6);

    public abstract void addAggregateValue(Aggregator var1, long var2, long var4);

    public void finished(AggregateQueryMetadata metadata) {
    }
}

