/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdatepicker.ComponentIconDefaults;
import org.jdatepicker.DateModel;
import org.jdatepicker.DatePanel;
import org.jdatepicker.SqlDateModel;
import org.jdatepicker.UtilCalendarModel;
import org.jdatepicker.UtilDateModel;
import org.jdatepicker.constraints.DateSelectionConstraint;
import utils.progtools.date.DateUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class JDatePanel
extends JComponent
implements DatePanel {
    private static final long serialVersionUID = -2299249311312882915L;
    private ResourceBundle lang;
    private Set<ActionListener> actionListeners;
    private Set<DateSelectionConstraint> dateConstraints;
    private boolean showYearButtons;
    private boolean doubleClickAction;
    private int firstDayOfWeek;
    private InternalCalendarModel internalModel;
    private InternalController internalController;
    private InternalView internalView;
    private ComponentIconDefaults icons;

    public JDatePanel(ResourceBundle lang, Icon clearIcon) {
        this(lang, clearIcon, JDatePanel.createModel());
    }

    public JDatePanel(ResourceBundle lang, Icon clearIcon, Calendar value) {
        this(lang, clearIcon, JDatePanel.createModelFromValue(value));
    }

    public JDatePanel(ResourceBundle lang, Icon clearIcon, java.util.Date value) {
        this(lang, clearIcon, JDatePanel.createModelFromValue(value));
    }

    public JDatePanel(ResourceBundle lang, Icon clearIcon, Date value) {
        this(lang, clearIcon, JDatePanel.createModelFromValue(value));
    }

    public JDatePanel(ResourceBundle lang, Icon clearIcon, DateModel<?> model) {
        this.lang = lang;
        this.icons = ComponentIconDefaults.getInstance();
        this.icons.setClearIcon(clearIcon);
        this.actionListeners = new HashSet<ActionListener>();
        this.dateConstraints = new HashSet<DateSelectionConstraint>();
        this.showYearButtons = false;
        this.doubleClickAction = false;
        this.firstDayOfWeek = Calendar.getInstance().getFirstDayOfWeek();
        this.internalModel = new InternalCalendarModel(model);
        this.internalController = new InternalController();
        this.internalView = new InternalView();
        this.setLayout(new GridLayout(1, 1));
        this.add(this.internalView);
    }

    public static DateModel<Calendar> createModel() {
        return new UtilCalendarModel();
    }

    private static DateModel<Calendar> createModel(Calendar value) {
        return new UtilCalendarModel(value);
    }

    private static DateModel<?> createModelFromValue(Object value) {
        if (value instanceof Calendar) {
            return new UtilCalendarModel((Calendar)value);
        }
        if (value instanceof Date) {
            return new SqlDateModel((Date)value);
        }
        if (value instanceof java.util.Date) {
            return new UtilDateModel((java.util.Date)value);
        }
        throw new IllegalArgumentException("No model could be constructed from the initial value object.");
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, "Date selected"));
        }
    }

    @Override
    public void setShowYearButtons(boolean showYearButtons) {
        this.showYearButtons = showYearButtons;
        this.internalView.updateShowYearButtons();
    }

    @Override
    public boolean isShowYearButtons() {
        return this.showYearButtons;
    }

    @Override
    public void setDoubleClickAction(boolean doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    @Override
    public boolean isDoubleClickAction() {
        return this.doubleClickAction;
    }

    @Override
    public DateModel<?> getModel() {
        return this.internalModel.getModel();
    }

    @Override
    public void addDateSelectionConstraint(DateSelectionConstraint constraint) {
        this.dateConstraints.add(constraint);
    }

    @Override
    public void removeDateSelectionConstraint(DateSelectionConstraint constraint) {
        this.dateConstraints.remove(constraint);
    }

    @Override
    public void removeAllDateSelectionConstraints() {
        this.dateConstraints.clear();
    }

    @Override
    public Set<DateSelectionConstraint> getDateSelectionConstraints() {
        return Collections.unmodifiableSet(this.dateConstraints);
    }

    protected boolean checkConstraints(DateModel<?> model) {
        for (DateSelectionConstraint constraint : this.dateConstraints) {
            if (constraint.isValidSelection(model)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.internalView.updateTodayLabel();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.internalView.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    protected class InternalCalendarModel
    implements TableModel,
    SpinnerModel,
    ChangeListener {
        private DateModel<?> model;
        private Set<ChangeListener> spinnerChangeListeners = new HashSet<ChangeListener>();
        private Set<TableModelListener> tableModelListeners = new HashSet<TableModelListener>();
        private int[] lookup = null;

        public InternalCalendarModel(DateModel<?> model) {
            this.model = model;
            model.addChangeListener(this);
        }

        public DateModel<?> getModel() {
            return this.model;
        }

        @Override
        public void addChangeListener(ChangeListener arg0) {
            this.spinnerChangeListeners.add(arg0);
        }

        @Override
        public void removeChangeListener(ChangeListener arg0) {
            this.spinnerChangeListeners.remove(arg0);
        }

        @Override
        public Object getNextValue() {
            return Integer.toString(this.model.getYear() + 1);
        }

        @Override
        public Object getPreviousValue() {
            return Integer.toString(this.model.getYear() - 1);
        }

        @Override
        public void setValue(Object text) {
            String year = (String)text;
            this.model.setYear(Integer.parseInt(year));
        }

        @Override
        public Object getValue() {
            return Integer.toString(this.model.getYear());
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.tableModelListeners.add(arg0);
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            this.tableModelListeners.remove(arg0);
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return 6;
        }

        @Override
        public String getColumnName(int columnIndex) {
            int index = (JDatePanel.this.firstDayOfWeek + columnIndex) % 7;
            return DateUtil.getDayOfWeekString(index);
        }

        private int[] lookup() {
            if (this.lookup == null) {
                this.lookup = new int[8];
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek - 1) % 7] = 0;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 0) % 7] = 1;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 1) % 7] = 2;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 2) % 7] = 3;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 3) % 7] = 4;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 4) % 7] = 5;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 5) % 7] = 6;
            }
            return this.lookup;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int series = columnIndex + rowIndex * 7 + 1;
            Calendar firstOfMonth = Calendar.getInstance();
            firstOfMonth.set(this.model.getYear(), this.model.getMonth(), 1);
            int dowForFirst = firstOfMonth.get(7);
            int daysBefore = this.lookup()[dowForFirst - 1];
            return series - daysBefore;
        }

        public Class getColumnClass(int arg0) {
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public void setValueAt(Object arg0, int arg1, int arg2) {
        }

        private void fireValueChanged() {
            for (ChangeListener cl : this.spinnerChangeListeners) {
                cl.stateChanged(new ChangeEvent(this));
            }
            JDatePanel.this.internalView.updateMonthLabel();
            for (TableModelListener tl : this.tableModelListeners) {
                tl.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireValueChanged();
        }
    }

    private class InternalController
    implements ActionListener,
    MouseListener {
        private InternalController() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!JDatePanel.this.isEnabled()) {
                return;
            }
            if (arg0.getSource() == JDatePanel.this.internalView.getNextMonthButton()) {
                JDatePanel.this.internalModel.getModel().addMonth(1);
            } else if (arg0.getSource() == JDatePanel.this.internalView.getPreviousMonthButton()) {
                JDatePanel.this.internalModel.getModel().addMonth(-1);
            } else if (arg0.getSource() == JDatePanel.this.internalView.getNextYearButton()) {
                JDatePanel.this.internalModel.getModel().addYear(1);
            } else if (arg0.getSource() == JDatePanel.this.internalView.getPreviousYearButton()) {
                JDatePanel.this.internalModel.getModel().addYear(-1);
            } else {
                for (int month = 0; month < JDatePanel.this.internalView.getMonthPopupMenuItems().length; ++month) {
                    if (arg0.getSource() != JDatePanel.this.internalView.getMonthPopupMenuItems()[month]) continue;
                    JDatePanel.this.internalModel.getModel().setMonth(month);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (!JDatePanel.this.isEnabled()) {
                return;
            }
            if (arg0.getSource() == JDatePanel.this.internalView.getMonthLabel()) {
                JDatePanel.this.internalView.getMonthPopupMenu().setLightWeightPopupEnabled(false);
                JDatePanel.this.internalView.getMonthPopupMenu().show((Component)arg0.getSource(), arg0.getX(), arg0.getY());
            } else if (arg0.getSource() == JDatePanel.this.internalView.getTodayLabel()) {
                Calendar today = Calendar.getInstance();
                JDatePanel.this.internalModel.getModel().setDate(today.get(1), today.get(2), today.get(5));
            } else if (arg0.getSource() == JDatePanel.this.internalView.getDayTable()) {
                int row = JDatePanel.this.internalView.getDayTable().getSelectedRow();
                int col = JDatePanel.this.internalView.getDayTable().getSelectedColumn();
                if (row >= 0 && row <= 5) {
                    Integer date = (Integer)JDatePanel.this.internalModel.getValueAt(row, col);
                    int oldDay = JDatePanel.this.internalModel.getModel().getDay();
                    JDatePanel.this.internalModel.getModel().setDay(date);
                    if (!JDatePanel.this.checkConstraints(JDatePanel.this.internalModel.getModel())) {
                        JDatePanel.this.internalModel.getModel().setDay(oldDay);
                        return;
                    }
                    JDatePanel.this.internalModel.getModel().setSelected(true);
                    if (JDatePanel.this.doubleClickAction && arg0.getClickCount() == 2) {
                        JDatePanel.this.fireActionPerformed();
                    }
                    if (!JDatePanel.this.doubleClickAction) {
                        JDatePanel.this.fireActionPerformed();
                    }
                }
            } else if (arg0.getSource() == JDatePanel.this.internalView.getNoneLabel()) {
                JDatePanel.this.internalModel.getModel().setSelected(false);
                if (JDatePanel.this.doubleClickAction && arg0.getClickCount() == 2) {
                    JDatePanel.this.fireActionPerformed();
                }
                if (!JDatePanel.this.doubleClickAction) {
                    JDatePanel.this.fireActionPerformed();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    private class InternalTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -2341614459632756921L;
        private boolean first = true;

        private InternalTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setHorizontalAlignment(0);
            if (row == -1) {
                label.setForeground(SHStyle.FG_GRID_HEADER);
                label.setBackground(SHStyle.BG_GRID_HEADER);
                label.setHorizontalAlignment(0);
                return label;
            }
            Calendar todayCal = Calendar.getInstance();
            Calendar selectedCal = Calendar.getInstance();
            selectedCal.set(JDatePanel.this.internalModel.getModel().getYear(), JDatePanel.this.internalModel.getModel().getMonth(), JDatePanel.this.internalModel.getModel().getDay());
            int cellDayValue = (Integer)value;
            int lastDayOfMonth = selectedCal.getActualMaximum(5);
            if (cellDayValue < 1 || cellDayValue > lastDayOfMonth) {
                label.setForeground(UIManager.getColor("textInactiveText"));
                Calendar calForDay = Calendar.getInstance();
                calForDay.set(JDatePanel.this.internalModel.getModel().getYear(), JDatePanel.this.internalModel.getModel().getMonth(), cellDayValue);
                UtilCalendarModel modelForDay = new UtilCalendarModel(calForDay);
                label.setBackground(JDatePanel.this.checkConstraints(modelForDay) ? SHStyle.BG_GRID : SHStyle.BG_GRID_NOT_SELECTABLE);
                if (cellDayValue > lastDayOfMonth) {
                    label.setText(Integer.toString(cellDayValue - lastDayOfMonth));
                } else {
                    GregorianCalendar lastMonth = new GregorianCalendar();
                    lastMonth.set(selectedCal.get(1), selectedCal.get(2) - 1, 1);
                    int lastDayLastMonth = ((Calendar)lastMonth).getActualMaximum(5);
                    label.setText(Integer.toString(lastDayLastMonth + cellDayValue));
                }
            } else {
                label.setForeground(UIManager.getColor("textText"));
                Calendar calForDay = Calendar.getInstance();
                calForDay.set(JDatePanel.this.internalModel.getModel().getYear(), JDatePanel.this.internalModel.getModel().getMonth(), cellDayValue);
                UtilCalendarModel modelForDay = new UtilCalendarModel(calForDay);
                label.setBackground(JDatePanel.this.checkConstraints(modelForDay) ? SHStyle.BG_GRID : SHStyle.BG_GRID_NOT_SELECTABLE);
                if (todayCal.get(5) == cellDayValue && todayCal.get(2) == JDatePanel.this.internalModel.getModel().getMonth() && todayCal.get(1) == JDatePanel.this.internalModel.getModel().getYear()) {
                    label.setForeground(SHStyle.FG_GRID_TODAY);
                    if (JDatePanel.this.internalModel.getModel().isSelected() && selectedCal.get(5) == cellDayValue) {
                        label.setForeground(SHStyle.FG_GRID_TODAY_SELECTED);
                        label.setBackground(SHStyle.BG_GRID_TODAY_SELECTED);
                    }
                } else if (JDatePanel.this.internalModel.getModel().isSelected() && selectedCal.get(5) == cellDayValue) {
                    label.setForeground(SHStyle.FG_GRID_SELECTED);
                    label.setBackground(SHStyle.BG_GRID_SELECTED);
                }
            }
            return label;
        }
    }

    private class InternalView
    extends JPanel {
        private static final long serialVersionUID = -6844493839307157682L;
        private DateFormat todayLabelFormatter = SimpleDateFormat.getDateInstance(2);
        private JPanel centerPanel;
        private JPanel northCenterPanel;
        private JPanel northPanel;
        private JPanel southPanel;
        private JPanel previousButtonPanel;
        private JPanel nextButtonPanel;
        private JTable dayTable;
        private JTableHeader dayTableHeader;
        private InternalTableCellRenderer dayTableCellRenderer;
        private JLabel monthLabel;
        private JLabel todayLabel;
        private JLabel noneLabel;
        private JPopupMenu monthPopupMenu;
        private JMenuItem[] monthPopupMenuItems;
        private JButton nextMonthButton;
        private JButton previousMonthButton;
        private JButton previousYearButton;
        private JButton nextYearButton;
        private JSpinner yearSpinner;

        private void updateShowYearButtons() {
            if (JDatePanel.this.showYearButtons) {
                this.getNextButtonPanel().add(this.getNextYearButton());
                this.getPreviousButtonPanel().removeAll();
                this.getPreviousButtonPanel().add(this.getPreviousYearButton());
                this.getPreviousButtonPanel().add(this.getPreviousMonthButton());
            } else {
                this.getNextButtonPanel().remove(this.getNextYearButton());
                this.getPreviousButtonPanel().remove(this.getPreviousYearButton());
            }
        }

        private void updateMonthLabel() {
            int month = JDatePanel.this.internalModel.getModel().getMonth();
            this.monthLabel.setText(DateUtil.getMonthString(month));
        }

        public InternalView() {
            this.initialise();
        }

        private void initialise() {
            this.setLayout(new BorderLayout());
            Dimension size = SimpleHelpLookAndFeel.scale((Dimension)new Dimension(250, 200));
            this.setSize(size);
            this.setPreferredSize(size);
            this.setOpaque(false);
            this.add((Component)this.getNorthPanel(), "North");
            this.add((Component)this.getSouthPanel(), "South");
            this.add((Component)this.getCenterPanel(), "Center");
        }

        private JPanel getNorthPanel() {
            if (this.northPanel == null) {
                this.northPanel = new JPanel();
                this.northPanel.setLayout(new BorderLayout());
                this.northPanel.setName("");
                this.northPanel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
                this.northPanel.add((Component)this.getPreviousButtonPanel(), "West");
                this.northPanel.add((Component)this.getNextButtonPanel(), "East");
                this.northPanel.add((Component)this.getNorthCenterPanel(), "Center");
            }
            return this.northPanel;
        }

        private JPanel getNorthCenterPanel() {
            if (this.northCenterPanel == null) {
                this.northCenterPanel = new JPanel();
                this.northCenterPanel.setLayout(new BorderLayout());
                this.northCenterPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)5));
                this.northCenterPanel.setOpaque(false);
                this.northCenterPanel.add((Component)this.getMonthLabel(), "Center");
                this.northCenterPanel.add((Component)this.getYearSpinner(), "East");
            }
            return this.northCenterPanel;
        }

        private JLabel getMonthLabel() {
            if (this.monthLabel == null) {
                this.monthLabel = new JLabel();
                this.monthLabel.setHorizontalAlignment(0);
                this.monthLabel.addMouseListener(JDatePanel.this.internalController);
                this.updateMonthLabel();
            }
            return this.monthLabel;
        }

        private JSpinner getYearSpinner() {
            if (this.yearSpinner == null) {
                this.yearSpinner = new JSpinner();
                this.yearSpinner.setModel(JDatePanel.this.internalModel);
                this.yearSpinner.setBackground(UIManager.getColor("TextField.disabledBackground"));
            }
            return this.yearSpinner;
        }

        private JPanel getSouthPanel() {
            if (this.southPanel == null) {
                this.southPanel = new JPanel();
                this.southPanel.setLayout(new BorderLayout());
                this.southPanel.setBackground(SHStyle.BG_TODAY_SELECTOR);
                this.southPanel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
                this.southPanel.add((Component)this.getTodayLabel(), "West");
                this.southPanel.add((Component)this.getNoneLabel(), "East");
            }
            return this.southPanel;
        }

        private JLabel getNoneLabel() {
            if (this.noneLabel == null) {
                this.noneLabel = new JLabel();
                this.noneLabel.setForeground(UIManager.getColor("textText"));
                this.noneLabel.setHorizontalAlignment(0);
                this.noneLabel.addMouseListener(JDatePanel.this.internalController);
                this.noneLabel.setIcon(JDatePanel.this.icons.getClearIcon());
            }
            return this.noneLabel;
        }

        private void updateTodayLabel() {
            Calendar now = Calendar.getInstance();
            this.todayLabel.setText(JDatePanel.this.lang.getString("TODAY") + ": " + this.todayLabelFormatter.format(now.getTime()));
        }

        private JLabel getTodayLabel() {
            if (this.todayLabel == null) {
                this.todayLabel = new JLabel();
                this.todayLabel.setForeground(UIManager.getColor("textText"));
                this.todayLabel.setHorizontalAlignment(0);
                this.todayLabel.addMouseListener(JDatePanel.this.internalController);
                this.updateTodayLabel();
            }
            return this.todayLabel;
        }

        private JPanel getCenterPanel() {
            if (this.centerPanel == null) {
                this.centerPanel = new JPanel();
                this.centerPanel.setLayout(new BorderLayout());
                this.centerPanel.setOpaque(false);
                this.centerPanel.add((Component)this.getDayTableHeader(), "North");
                this.centerPanel.add((Component)this.getDayTable(), "Center");
            }
            return this.centerPanel;
        }

        private JTable getDayTable() {
            if (this.dayTable == null) {
                this.dayTable = new JTable();
                this.dayTable.setAutoResizeMode(4);
                this.dayTable.setModel(JDatePanel.this.internalModel);
                this.dayTable.setShowGrid(true);
                this.dayTable.setGridColor(SHStyle.BG_GRID);
                this.dayTable.setSelectionMode(0);
                this.dayTable.setCellSelectionEnabled(true);
                this.dayTable.setRowSelectionAllowed(true);
                this.dayTable.setFocusable(false);
                this.dayTable.addMouseListener(JDatePanel.this.internalController);
                for (int i = 0; i < 7; ++i) {
                    TableColumn column = this.dayTable.getColumnModel().getColumn(i);
                    column.setCellRenderer(this.getDayTableCellRenderer());
                }
                this.dayTable.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        InternalView.this.tableResized();
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                        InternalView.this.tableResized();
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }
                });
            }
            return this.dayTable;
        }

        private InternalTableCellRenderer getDayTableCellRenderer() {
            if (this.dayTableCellRenderer == null) {
                this.dayTableCellRenderer = new InternalTableCellRenderer();
            }
            return this.dayTableCellRenderer;
        }

        private JTableHeader getDayTableHeader() {
            if (this.dayTableHeader == null) {
                this.dayTableHeader = this.getDayTable().getTableHeader();
                this.dayTableHeader.setResizingAllowed(false);
                this.dayTableHeader.setReorderingAllowed(false);
                this.dayTableHeader.setDefaultRenderer(this.getDayTableCellRenderer());
            }
            return this.dayTableHeader;
        }

        private JPanel getPreviousButtonPanel() {
            if (this.previousButtonPanel == null) {
                this.previousButtonPanel = new JPanel();
                GridLayout layout = new GridLayout(1, 2);
                layout.setHgap(SimpleHelpLookAndFeel.scale((int)3));
                this.previousButtonPanel.setLayout(layout);
                this.previousButtonPanel.setName("");
                this.previousButtonPanel.setOpaque(false);
                if (JDatePanel.this.isShowYearButtons()) {
                    this.previousButtonPanel.add(this.getPreviousYearButton());
                }
                this.previousButtonPanel.add(this.getPreviousMonthButton());
            }
            return this.previousButtonPanel;
        }

        private JPanel getNextButtonPanel() {
            if (this.nextButtonPanel == null) {
                this.nextButtonPanel = new JPanel();
                GridLayout layout = new GridLayout(1, 2);
                layout.setHgap(SimpleHelpLookAndFeel.scale((int)3));
                this.nextButtonPanel.setLayout(layout);
                this.nextButtonPanel.setName("");
                this.nextButtonPanel.setOpaque(false);
                this.nextButtonPanel.add(this.getNextMonthButton());
                if (JDatePanel.this.isShowYearButtons()) {
                    this.nextButtonPanel.add(this.getNextYearButton());
                }
            }
            return this.nextButtonPanel;
        }

        private JButton getNextMonthButton() {
            if (this.nextMonthButton == null) {
                this.nextMonthButton = new JButton();
                this.nextMonthButton.setIcon(JDatePanel.this.icons.getNextMonthIconEnabled());
                this.nextMonthButton.setDisabledIcon(JDatePanel.this.icons.getNextMonthIconDisabled());
                this.nextMonthButton.setText("");
                this.nextMonthButton.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(20, 15)));
                this.nextMonthButton.setFocusable(false);
                this.nextMonthButton.setOpaque(true);
                this.nextMonthButton.addActionListener(JDatePanel.this.internalController);
            }
            return this.nextMonthButton;
        }

        private JButton getNextYearButton() {
            if (this.nextYearButton == null) {
                this.nextYearButton = new JButton();
                this.nextYearButton.setIcon(JDatePanel.this.icons.getNextYearIconEnabled());
                this.nextYearButton.setDisabledIcon(JDatePanel.this.icons.getNextYearIconDisabled());
                this.nextYearButton.setText("");
                this.nextYearButton.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(20, 15)));
                this.nextYearButton.setFocusable(false);
                this.nextYearButton.setOpaque(true);
                this.nextYearButton.addActionListener(JDatePanel.this.internalController);
            }
            return this.nextYearButton;
        }

        private JButton getPreviousMonthButton() {
            if (this.previousMonthButton == null) {
                this.previousMonthButton = new JButton();
                this.previousMonthButton.setIcon(JDatePanel.this.icons.getPreviousMonthIconEnabled());
                this.previousMonthButton.setDisabledIcon(JDatePanel.this.icons.getPreviousMonthIconDisabled());
                this.previousMonthButton.setText("");
                this.previousMonthButton.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(20, 15)));
                this.previousMonthButton.setFocusable(false);
                this.previousMonthButton.setOpaque(true);
                this.previousMonthButton.addActionListener(JDatePanel.this.internalController);
            }
            return this.previousMonthButton;
        }

        private JButton getPreviousYearButton() {
            if (this.previousYearButton == null) {
                this.previousYearButton = new JButton();
                this.previousYearButton.setIcon(JDatePanel.this.icons.getPreviousYearIconEnabled());
                this.previousYearButton.setDisabledIcon(JDatePanel.this.icons.getPreviousYearIconDisabled());
                this.previousYearButton.setText("");
                this.previousYearButton.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(20, 15)));
                this.previousYearButton.setFocusable(false);
                this.previousYearButton.setOpaque(true);
                this.previousYearButton.addActionListener(JDatePanel.this.internalController);
            }
            return this.previousYearButton;
        }

        private JPopupMenu getMonthPopupMenu() {
            if (this.monthPopupMenu == null) {
                JMenuItem[] menuItems;
                this.monthPopupMenu = new JPopupMenu();
                for (JMenuItem menuItem : menuItems = this.getMonthPopupMenuItems()) {
                    this.monthPopupMenu.add(menuItem);
                }
            }
            return this.monthPopupMenu;
        }

        private JMenuItem[] getMonthPopupMenuItems() {
            if (this.monthPopupMenuItems == null) {
                this.monthPopupMenuItems = new JMenuItem[12];
                for (int i = 0; i < 12; ++i) {
                    JMenuItem mi = new JMenuItem(DateUtil.getMonthString(i));
                    mi.addActionListener(JDatePanel.this.internalController);
                    this.monthPopupMenuItems[i] = mi;
                }
            }
            return this.monthPopupMenuItems;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.dayTable.setEnabled(enabled);
            this.dayTableCellRenderer.setEnabled(enabled);
            this.nextMonthButton.setEnabled(enabled);
            if (this.nextYearButton != null) {
                this.nextYearButton.setEnabled(enabled);
            }
            this.previousMonthButton.setEnabled(enabled);
            if (this.previousYearButton != null) {
                this.previousYearButton.setEnabled(enabled);
            }
            this.yearSpinner.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        private void tableResized() {
            double w = this.dayTable.getSize().getWidth();
            double h = this.dayTable.getSize().getHeight();
            float sw = (float)Math.floor(w / 16.0);
            float sh = (float)Math.floor(h / 8.0);
            this.dayTable.setFont(this.dayTable.getFont().deriveFont(Math.min(sw, sh)));
            int r = (int)Math.floor(h / 6.0);
            this.dayTable.setRowHeight(r);
        }
    }
}

